/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.spi.structure.helpers;

import java.io.IOException;
import org.jboss.deployers.spi.structure.ContextInfo;
import org.jboss.deployers.spi.structure.StructureMetaData;
import org.jboss.deployers.vfs.spi.structure.StructureContext;
import org.jboss.deployers.vfs.spi.structure.helpers.AbstractStructureDeployer;
import org.jboss.deployers.vfs.spi.structure.helpers.SecurityActions;
import org.jboss.logging.Logger;
import org.jboss.virtual.VirtualFile;
import org.jboss.virtual.VirtualFileFilter;
import org.jboss.virtual.VisitorAttributes;
import org.jboss.virtual.plugins.vfs.helpers.AbstractVirtualFileVisitor;

public class AbstractCandidateStructureVisitor
extends AbstractVirtualFileVisitor {
    private static final Logger log = Logger.getLogger(AbstractCandidateStructureVisitor.class);
    private StructureContext context;
    private boolean ignoreDirectories;
    private VirtualFileFilter filter;

    public AbstractCandidateStructureVisitor(StructureContext context) {
        this(context, null);
    }

    public AbstractCandidateStructureVisitor(StructureContext context, VisitorAttributes attributes) {
        super(attributes);
        if (context == null) {
            throw new IllegalArgumentException("Null context");
        }
        this.context = context;
    }

    public VirtualFile getParent() {
        return this.context.getFile();
    }

    public boolean isIgnoreDirectories() {
        return this.ignoreDirectories;
    }

    public VirtualFileFilter getFilter() {
        return this.filter;
    }

    public void setFilter(VirtualFileFilter filter) {
        this.filter = filter;
    }

    public void setIgnoreDirectories(boolean ignoreDirectories) {
        this.ignoreDirectories = ignoreDirectories;
    }

    public void visit(VirtualFile file) {
        String path = AbstractStructureDeployer.getRelativePath(this.context, file);
        StructureMetaData metaData = this.context.getMetaData();
        ContextInfo contextInfo = metaData.getContext(path);
        if (contextInfo == null) {
            try {
                if (this.ignoreDirectories && !SecurityActions.isLeaf(file)) {
                    return;
                }
            }
            catch (IOException e) {
                log.debug((Object)("Ignoring " + file + " reason=" + e));
                return;
            }
            if (this.filter != null && !this.filter.accepts(file)) {
                return;
            }
            try {
                this.context.determineChildStructure(file);
            }
            catch (Exception e) {
                log.debug((Object)("Ignoring " + file + " reason=" + e));
            }
        }
    }
}

