/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.plugin.deployment.common;

import java.io.Closeable;
import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.security.auth.callback.CallbackHandler;
import org.apache.maven.plugin.AbstractMojo;
import org.jboss.as.plugin.deployment.ConnectionInfo;
import org.jboss.as.plugin.deployment.common.ClientCallbackHandler;
import org.jboss.as.plugin.deployment.domain.Domain;

public abstract class AbstractServerConnection
extends AbstractMojo
implements ConnectionInfo {
    private volatile InetAddress address = null;
    private volatile CallbackHandler handler;
    private String hostname;
    private int port;
    private String username;
    private String password;
    private Domain domain;

    public final String hostname() {
        return this.hostname;
    }

    @Override
    public final int getPort() {
        return this.port;
    }

    public final boolean isDomainServer() {
        return this.domain != null;
    }

    public final Domain getDomain() {
        return this.domain;
    }

    public abstract String goal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final InetAddress getHostAddress() {
        InetAddress result = this.address;
        if (result == null) {
            AbstractServerConnection abstractServerConnection = this;
            synchronized (abstractServerConnection) {
                result = this.address;
                if (result == null) {
                    try {
                        result = this.address = InetAddress.getByName(this.hostname());
                    }
                    catch (UnknownHostException e) {
                        throw new IllegalArgumentException(String.format("Host name '%s' is invalid.", this.hostname), e);
                    }
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final CallbackHandler getCallbackHandler() {
        CallbackHandler result = this.handler;
        if (result == null) {
            AbstractServerConnection abstractServerConnection = this;
            synchronized (abstractServerConnection) {
                result = this.handler;
                if (result == null) {
                    result = this.handler = new ClientCallbackHandler(this.username, this.password);
                }
            }
        }
        return result;
    }

    public void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)("Error closing " + closeable));
            }
        }
    }
}

