/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.services.net;

import java.util.List;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.operations.common.AbstractSocketBindingGroupAddHandler;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.resource.SocketBindingGroupResourceDefinition;
import org.jboss.as.network.NetworkInterfaceBinding;
import org.jboss.as.network.SocketBindingManager;
import org.jboss.as.server.services.net.NetworkInterfaceService;
import org.jboss.as.server.services.net.SocketBindingManagerService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;

public class BindingGroupAddHandler
extends AbstractSocketBindingGroupAddHandler {
    public static final BindingGroupAddHandler INSTANCE = new BindingGroupAddHandler();

    public static ModelNode getOperation(ModelNode address, ModelNode model) {
        ModelNode op = Util.getEmptyOperation((String)"add", (ModelNode)address);
        op.get("default-interface").set(model.get("default-interface"));
        op.get("port-offset").set(model.get("port-offset"));
        return op;
    }

    private BindingGroupAddHandler() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        super.populateModel(operation, model);
        SocketBindingGroupResourceDefinition.PORT_OFFSET.validateAndSet(operation, model);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        int portOffset = SocketBindingGroupResourceDefinition.PORT_OFFSET.resolveModelAttribute(context, model).asInt();
        String defaultInterface = SocketBindingGroupResourceDefinition.DEFAULT_INTERFACE.resolveModelAttribute(context, model).asString();
        SocketBindingManagerService service = new SocketBindingManagerService(portOffset);
        ServiceTarget serviceTarget = context.getServiceTarget();
        newControllers.add(serviceTarget.addService(SocketBindingManager.SOCKET_BINDING_MANAGER, (Service)service).setInitialMode(ServiceController.Mode.ON_DEMAND).addDependency(NetworkInterfaceService.JBOSS_NETWORK_INTERFACE.append(new String[]{defaultInterface}), NetworkInterfaceBinding.class, service.getDefaultInterfaceBindingInjector()).addListener((ServiceListener)verificationHandler).install());
    }
}

