/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.util.Locale;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.server.controller.descriptions.ServerDescriptions;
import org.jboss.as.server.deployment.Services;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceName;

public class DeploymentRemoveHandler
implements OperationStepHandler,
DescriptionProvider {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.server.controller");
    public static final String OPERATION_NAME = "remove";
    public static final DeploymentRemoveHandler INSTANCE = new DeploymentRemoveHandler();

    private DeploymentRemoveHandler() {
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        final ModelNode model = context.readModel(PathAddress.EMPTY_ADDRESS);
        context.removeResource(PathAddress.EMPTY_ADDRESS);
        if (context.getType() == OperationContext.Type.SERVER) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    boolean enabled;
                    String deploymentUnitName = null;
                    boolean bl = enabled = model.hasDefined("enabled") ? model.get("enabled").asBoolean() : true;
                    if (enabled) {
                        ModelNode opAddr = operation.get("address");
                        PathAddress address = PathAddress.pathAddress((ModelNode)opAddr);
                        String name = address.getLastElement().getValue();
                        deploymentUnitName = model.hasDefined("runtime-name") ? model.get("runtime-name").asString() : name;
                        ServiceName deploymentUnitServiceName = Services.deploymentUnitName(deploymentUnitName);
                        context.removeService(deploymentUnitServiceName);
                        context.removeService(deploymentUnitServiceName.append(new String[]{"contents"}));
                    }
                    if (context.completeStep() == OperationContext.ResultAction.ROLLBACK) {
                        DeploymentRemoveHandler.this.recoverServices(context, operation, model);
                        if (enabled && context.hasFailureDescription()) {
                            log.infof("Undeploy of deployment \"%s\" was rolled back with failure message %s", (Object)deploymentUnitName, (Object)context.getFailureDescription().asString());
                        } else if (enabled) {
                            log.infof("Undeploy of deployment \"%s\" was rolled back with no failure message", (Object)deploymentUnitName);
                        }
                    } else if (enabled) {
                        log.infof("Undeployed \"%s\"", deploymentUnitName);
                    }
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.completeStep();
    }

    protected boolean requiresRuntime(OperationContext context) {
        return context.getType() == OperationContext.Type.SERVER;
    }

    public ModelNode getModelDescription(Locale locale) {
        return ServerDescriptions.getRemoveDeploymentOperation(locale);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) {
        boolean enabled;
        boolean bl = enabled = model.hasDefined("enabled") ? model.get("enabled").asBoolean() : true;
        if (!enabled) {
            return;
        }
    }

    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) {
    }
}

