/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.jboss.as.controller.HashUtil;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.DeploymentDescription;
import org.jboss.as.controller.operations.validation.AbstractParameterValidator;
import org.jboss.as.controller.operations.validation.ChainedParameterValidator;
import org.jboss.as.controller.operations.validation.ListValidator;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersOfValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.server.deployment.AbstractDeploymentHandler;
import org.jboss.as.server.deployment.DeploymentHandlerUtil;
import org.jboss.as.server.deployment.repository.api.ContentRepository;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class DeploymentFullReplaceHandler
implements OperationStepHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "full-replace-deployment";
    private final ContentRepository contentRepository;
    private final ParametersValidator validator = new ParametersValidator();
    private final ParametersValidator unmanagedContentValidator = new ParametersValidator();
    private final ParametersValidator managedContentValidator = new ParametersValidator();

    public DeploymentFullReplaceHandler(ContentRepository contentRepository) {
        this.contentRepository = contentRepository;
        this.validator.registerValidator("name", (ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, false, false));
        this.validator.registerValidator("runtime-name", (ParameterValidator)new StringLengthValidator(1, Integer.MAX_VALUE, true, false));
        ParametersValidator contentValidator = new ParametersValidator();
        contentValidator.registerValidator("hash", (ParameterValidator)new ModelTypeValidator(ModelType.BYTES, true));
        contentValidator.registerValidator("archive", (ParameterValidator)new ModelTypeValidator(ModelType.BOOLEAN, true));
        contentValidator.registerValidator("path", (ParameterValidator)new StringLengthValidator(1, true));
        contentValidator.registerValidator("relative-to", (ParameterValidator)new ModelTypeValidator(ModelType.STRING, true));
        contentValidator.registerValidator("input-stream-index", (ParameterValidator)new ModelTypeValidator(ModelType.INT, true));
        contentValidator.registerValidator("bytes", (ParameterValidator)new ModelTypeValidator(ModelType.BYTES, true));
        contentValidator.registerValidator("url", (ParameterValidator)new StringLengthValidator(1, true));
        this.validator.registerValidator("content", ChainedParameterValidator.chain((ParameterValidator[])new ParameterValidator[]{new ListValidator((ParameterValidator)new ParametersOfValidator(contentValidator)), new AbstractParameterValidator(){

            public void validateParameter(String parameterName, ModelNode value) throws OperationFailedException {
                AbstractDeploymentHandler.validateOnePieceOfContent(value);
            }
        }}));
        this.managedContentValidator.registerValidator("hash", (ParameterValidator)new ModelTypeValidator(ModelType.BYTES));
        this.unmanagedContentValidator.registerValidator("archive", (ParameterValidator)new ModelTypeValidator(ModelType.BOOLEAN));
        this.unmanagedContentValidator.registerValidator("path", (ParameterValidator)new StringLengthValidator(1));
    }

    public ModelNode getModelDescription(Locale locale) {
        return DeploymentDescription.getFullReplaceDeploymentOperation((Locale)locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        DeploymentHandlerUtil.ContentItem contentItem;
        this.validator.validate(operation);
        String name = operation.require("name").asString();
        PathAddress address = PathAddress.EMPTY_ADDRESS.append(new PathElement[]{PathElement.pathElement((String)"deployment", (String)name)});
        Resource root = context.readResource(PathAddress.EMPTY_ADDRESS);
        boolean exists = root.hasChild(PathElement.pathElement((String)"deployment", (String)name));
        if (!exists) {
            throw AbstractDeploymentHandler.createFailureException("No deployment with name %s found", name);
        }
        ModelNode replaceNode = context.readModelForUpdate(address);
        String replacedRuntimeName = replaceNode.require("runtime-name").asString();
        String runtimeName = operation.hasDefined("runtime-name") ? operation.get("runtime-name").asString() : replaceNode.require("runtime-name").asString();
        ModelNode content = operation.require("content").clone();
        ModelNode contentItemNode = content.require(0);
        if (contentItemNode.hasDefined("hash")) {
            this.managedContentValidator.validate(contentItemNode);
            byte[] hash = contentItemNode.require("hash").asBytes();
            if (!this.contentRepository.hasContent(hash)) {
                throw AbstractDeploymentHandler.createFailureException("No deployment content with hash %s is available in the deployment content repository.", HashUtil.bytesToHexString((byte[])hash));
            }
            contentItem = new DeploymentHandlerUtil.ContentItem(hash);
        } else if (AbstractDeploymentHandler.hasValidContentAdditionParameterDefined(contentItemNode)) {
            byte[] hash;
            InputStream in = AbstractDeploymentHandler.getInputStream(context, contentItemNode);
            try {
                try {
                    hash = this.contentRepository.addContent(in);
                }
                catch (IOException e) {
                    throw AbstractDeploymentHandler.createFailureException(e.toString());
                }
            }
            finally {
                StreamUtils.safeClose((Closeable)in);
            }
            contentItemNode.clear();
            contentItemNode.get("hash").set(hash);
            contentItem = new DeploymentHandlerUtil.ContentItem(hash);
        } else {
            this.unmanagedContentValidator.validate(contentItemNode);
            String path = contentItemNode.require("path").asString();
            String relativeTo = AbstractDeploymentHandler.asString(contentItemNode, "relative-to");
            boolean archive = contentItemNode.require("archive").asBoolean();
            contentItem = new DeploymentHandlerUtil.ContentItem(path, relativeTo, archive);
        }
        boolean start = replaceNode.get("enabled").asBoolean();
        ModelNode deployNode = context.readModelForUpdate(address);
        deployNode.get("name").set(name);
        deployNode.get("runtime-name").set(runtimeName);
        deployNode.get("content").set(content);
        deployNode.get("enabled").set(start);
        DeploymentFullReplaceHandler.removeContentAdditions(deployNode.require("content"));
        if (start) {
            DeploymentHandlerUtil.replace(context, replaceNode, runtimeName, name, replacedRuntimeName, contentItem);
        }
        context.completeStep();
    }

    private static void removeAttributes(ModelNode node, Iterable<String> attributeNames) {
        for (String attributeName : attributeNames) {
            node.remove(attributeName);
        }
    }

    private static void removeContentAdditions(ModelNode content) {
        for (ModelNode contentItem : content.asList()) {
            DeploymentFullReplaceHandler.removeAttributes(contentItem, AbstractDeploymentHandler.CONTENT_ADDITION_PARAMETERS);
        }
    }
}

