/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.server.deployment.DeployerChainsService;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.deployment.Services;
import org.jboss.dmr.ModelNode;

public class DeployerChainAddHandler
implements OperationStepHandler,
DescriptionProvider {
    static final String NAME = "add-deployer-chains";
    public static final DeployerChainAddHandler INSTANCE = new DeployerChainAddHandler();
    static ModelNode OPERATION = new ModelNode();
    private final EnumMap<Phase, Set<RegisteredProcessor>> deployerMap;

    static void addDeploymentProcessor(Phase phase, int priority, DeploymentUnitProcessor processor) {
        EnumMap<Phase, Set<RegisteredProcessor>> deployerMap = DeployerChainAddHandler.INSTANCE.deployerMap;
        deployerMap.get((Object)phase).add(new RegisteredProcessor(priority, processor));
    }

    private DeployerChainAddHandler() {
        EnumMap map = new EnumMap(Phase.class);
        for (Phase phase : Phase.values()) {
            map.put(phase, new ConcurrentSkipListSet());
        }
        this.deployerMap = map;
    }

    public void clearDeployerMap() {
        for (Set<RegisteredProcessor> set : this.deployerMap.values()) {
            set.clear();
        }
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (context.getType() == OperationContext.Type.SERVER) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    context.addStep((OperationStepHandler)new FinalRuntimeStepHandler(), OperationContext.Stage.RUNTIME);
                    context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }

    public ModelNode getModelDescription(Locale locale) {
        return new ModelNode();
    }

    static {
        OPERATION.get("operation").set(NAME);
        OPERATION.get("address").setEmptyList();
    }

    static final class RegisteredProcessor
    implements Comparable<RegisteredProcessor> {
        private final int priority;
        private final DeploymentUnitProcessor processor;

        RegisteredProcessor(int priority, DeploymentUnitProcessor processor) {
            this.priority = priority;
            this.processor = processor;
        }

        @Override
        public int compareTo(RegisteredProcessor o) {
            int rel = Integer.signum(this.priority - o.priority);
            return rel == 0 ? this.processor.getClass().getName().compareTo(o.getClass().getName()) : rel;
        }

        int getPriority() {
            return this.priority;
        }

        DeploymentUnitProcessor getProcessor() {
            return this.processor;
        }
    }

    private class FinalRuntimeStepHandler
    implements OperationStepHandler {
        private FinalRuntimeStepHandler() {
        }

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            if (DeployerChainAddHandler.this.deployerMap == null) {
                throw new IllegalStateException("No deployers set");
            }
            EnumMap<Phase, List<DeploymentUnitProcessor>> finalDeployers = new EnumMap<Phase, List<DeploymentUnitProcessor>>(Phase.class);
            ArrayList<DeploymentUnitProcessor> processorList = new ArrayList<DeploymentUnitProcessor>(256);
            for (Phase phase : Phase.values()) {
                processorList.clear();
                Set processorSet = (Set)DeployerChainAddHandler.this.deployerMap.get((Object)phase);
                for (RegisteredProcessor processor : processorSet) {
                    processorList.add(processor.getProcessor());
                }
                finalDeployers.put(phase, Arrays.asList(processorList.toArray(new DeploymentUnitProcessor[processorList.size()])));
            }
            ServiceVerificationHandler verificationHandler = new ServiceVerificationHandler();
            DeployerChainsService.addService(context.getServiceTarget(), finalDeployers, verificationHandler);
            context.addStep((OperationStepHandler)verificationHandler, OperationContext.Stage.VERIFY);
            context.completeStep(new OperationContext.RollbackHandler(){

                public void handleRollback(OperationContext context, ModelNode operation) {
                    context.removeService(Services.JBOSS_DEPLOYMENT_CHAINS);
                }
            });
        }
    }
}

