/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.xml.namespace.QName;
import org.jboss.as.controller.parsing.Namespace;
import org.jboss.as.controller.persistence.BackupXmlConfigurationPersister;
import org.jboss.as.controller.persistence.ExtensibleConfigurationPersister;
import org.jboss.as.controller.persistence.NullConfigurationPersister;
import org.jboss.as.server.BootstrapImpl;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.parsing.StandaloneXml;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.ServiceActivator;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.threads.AsyncFuture;

public interface Bootstrap {
    public AsyncFuture<ServiceContainer> bootstrap(Configuration var1, List<ServiceActivator> var2);

    public AsyncFuture<ServiceContainer> startup(Configuration var1, List<ServiceActivator> var2);

    public static final class Factory {
        private Factory() {
        }

        public static Bootstrap newInstance() {
            return new BootstrapImpl();
        }
    }

    public static interface ConfigurationPersisterFactory {
        public ExtensibleConfigurationPersister createConfigurationPersister(ServerEnvironment var1, ExecutorService var2);
    }

    public static final class Configuration {
        private ServerEnvironment serverEnvironment;
        private ModuleLoader moduleLoader = Module.getBootModuleLoader();
        private ConfigurationPersisterFactory configurationPersisterFactory;
        private long startTime = Module.getStartTime();

        public void setPortOffset(int portOffset) {
            if (portOffset < 0) {
                throw new IllegalArgumentException("portOffset may not be less than 0");
            }
        }

        public ServerEnvironment getServerEnvironment() {
            return this.serverEnvironment;
        }

        public synchronized void setServerEnvironment(ServerEnvironment serverEnvironment) {
            this.serverEnvironment = serverEnvironment;
        }

        public ModuleLoader getModuleLoader() {
            return this.moduleLoader;
        }

        public void setModuleLoader(ModuleLoader moduleLoader) {
            this.moduleLoader = moduleLoader;
        }

        public synchronized ConfigurationPersisterFactory getConfigurationPersisterFactory() {
            if (this.configurationPersisterFactory == null) {
                if (this.serverEnvironment == null) {
                    final ModuleLoader localModuleLoader = this.moduleLoader;
                    this.configurationPersisterFactory = new ConfigurationPersisterFactory(){

                        @Override
                        public ExtensibleConfigurationPersister createConfigurationPersister(ServerEnvironment serverEnvironment, ExecutorService executorService) {
                            return new NullConfigurationPersister((XMLElementWriter)new StandaloneXml(localModuleLoader, executorService));
                        }
                    };
                } else {
                    this.configurationPersisterFactory = new ConfigurationPersisterFactory(){

                        @Override
                        public ExtensibleConfigurationPersister createConfigurationPersister(ServerEnvironment serverEnvironment, ExecutorService executorService) {
                            QName rootElement = new QName(Namespace.CURRENT.getUriString(), "server");
                            StandaloneXml parser = new StandaloneXml(Module.getBootModuleLoader(), executorService);
                            BackupXmlConfigurationPersister persister = new BackupXmlConfigurationPersister(serverEnvironment.getServerConfigurationFile(), rootElement, (XMLElementReader)parser, (XMLElementWriter)parser);
                            persister.registerAdditionalRootElement(new QName(Namespace.DOMAIN_1_0.getUriString(), "server"), (XMLElementReader)parser);
                            return persister;
                        }
                    };
                }
            }
            return this.configurationPersisterFactory;
        }

        public synchronized void setConfigurationPersisterFactory(ConfigurationPersisterFactory configurationPersisterFactory) {
            this.configurationPersisterFactory = configurationPersisterFactory;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public void setStartTime(long startTime) {
            this.startTime = startTime;
        }
    }
}

