/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import java.util.Locale;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.controller.operations.common.ProcessEnvironment;
import org.jboss.as.controller.operations.common.SecurityActions;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;

public class SystemPropertyRemoveHandler
implements OperationStepHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "remove";
    public static final SystemPropertyRemoveHandler INSTANCE = new SystemPropertyRemoveHandler(null);
    private final ProcessEnvironment processEnvironment;

    public static ModelNode getOperation(ModelNode address, String name) {
        ModelNode op = Util.getEmptyOperation(OPERATION_NAME, address);
        op.get("name").set(name);
        return op;
    }

    public SystemPropertyRemoveHandler(ProcessEnvironment processEnvironment) {
        this.processEnvironment = processEnvironment;
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        boolean reload;
        ModelNode model = Resource.Tools.readModel(context.readResource(PathAddress.EMPTY_ADDRESS));
        context.removeResource(PathAddress.EMPTY_ADDRESS);
        final String name = PathAddress.pathAddress(operation.get("address")).getLastElement().getValue();
        final String oldValue = model.hasDefined("value") ? model.get("value").asString() : null;
        boolean applyToRuntime = this.processEnvironment != null && this.processEnvironment.isRuntimeSystemPropertyUpdateAllowed(name, oldValue, context.isBooting());
        boolean bl = reload = !applyToRuntime && context.getProcessType().isServer();
        if (applyToRuntime) {
            context.addStep(new OperationStepHandler(){

                @Override
                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    SecurityActions.clearSystemProperty(name);
                    if (SystemPropertyRemoveHandler.this.processEnvironment != null) {
                        SystemPropertyRemoveHandler.this.processEnvironment.systemPropertyUpdated(name, null);
                    }
                    context.completeStep(new OperationContext.RollbackHandler(){

                        @Override
                        public void handleRollback(OperationContext context, ModelNode operation) {
                            SecurityActions.setSystemProperty(name, oldValue);
                            if (SystemPropertyRemoveHandler.this.processEnvironment != null) {
                                SystemPropertyRemoveHandler.this.processEnvironment.systemPropertyUpdated(name, oldValue);
                            }
                        }
                    });
                }
            }, OperationContext.Stage.RUNTIME);
        } else if (reload) {
            context.reloadRequired();
        }
        context.completeStep(new OperationContext.RollbackHandler(){

            @Override
            public void handleRollback(OperationContext context, ModelNode operation) {
                if (reload) {
                    context.revertReloadRequired();
                }
            }
        });
    }

    @Override
    public ModelNode getModelDescription(Locale locale) {
        return CommonDescriptions.getRemoveSystemPropertyOperation(locale);
    }
}

