/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.protocol.servlet.v_2_5;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jboss.arquillian.container.test.spi.TestDeployment;
import org.jboss.arquillian.container.test.spi.client.deployment.DeploymentPackager;
import org.jboss.arquillian.container.test.spi.client.deployment.ProtocolArchiveProcessor;
import org.jboss.arquillian.protocol.servlet.Processor;
import org.jboss.arquillian.protocol.servlet.ServletUtil;
import org.jboss.arquillian.protocol.servlet.arq514hack.descriptors.api.application.ApplicationDescriptor;
import org.jboss.arquillian.protocol.servlet.arq514hack.descriptors.api.web.WebAppDescriptor;
import org.jboss.arquillian.protocol.servlet.v_2_5.ProtocolDeploymentAppender;
import org.jboss.arquillian.protocol.servlet.v_2_5.WebUtils;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletProtocolDeploymentPackager
implements DeploymentPackager {
    public Archive<?> generateDeployment(TestDeployment testDeployment, Collection<ProtocolArchiveProcessor> processors) {
        WebArchive protocol = new ProtocolDeploymentAppender().createAuxiliaryArchive();
        Archive applicationArchive = testDeployment.getApplicationArchive();
        Collection auxiliaryArchives = testDeployment.getAuxiliaryArchives();
        Processor processor = new Processor(testDeployment, processors);
        if (EnterpriseArchive.class.isInstance(applicationArchive)) {
            return this.handleArchive((EnterpriseArchive)EnterpriseArchive.class.cast(applicationArchive), auxiliaryArchives, protocol, processor, testDeployment);
        }
        if (WebArchive.class.isInstance(applicationArchive)) {
            return this.handleArchive((WebArchive)WebArchive.class.cast(applicationArchive), auxiliaryArchives, protocol, processor);
        }
        if (JavaArchive.class.isInstance(applicationArchive)) {
            return this.handleArchive((JavaArchive)JavaArchive.class.cast(applicationArchive), auxiliaryArchives, protocol, processor);
        }
        throw new IllegalArgumentException(ServletProtocolDeploymentPackager.class.getName() + " can not handle archive of type " + applicationArchive.getClass().getName());
    }

    private Archive<?> handleArchive(WebArchive applicationArchive, Collection<Archive<?>> auxiliaryArchives, WebArchive protocol, Processor processor) {
        if (applicationArchive.contains(ServletUtil.WEB_XML_PATH)) {
            WebAppDescriptor applicationWebXml = (WebAppDescriptor)Descriptors.importAs(WebAppDescriptor.class).from(applicationArchive.get(ServletUtil.WEB_XML_PATH).getAsset().openStream());
            applicationArchive.delete(ServletUtil.WEB_XML_PATH);
            applicationArchive.setWebXML((Asset)new StringAsset(WebUtils.mergeWithDescriptor(applicationWebXml).exportAsString()));
            applicationArchive.merge((Archive)protocol, Filters.exclude((String)".*web\\.xml.*"));
        } else {
            applicationArchive.merge((Archive)protocol);
        }
        applicationArchive.addAsLibraries(auxiliaryArchives.toArray(new Archive[0]));
        processor.process((Archive<?>)applicationArchive);
        return applicationArchive;
    }

    private Archive<?> handleArchive(JavaArchive applicationArchive, Collection<Archive<?>> auxiliaryArchives, WebArchive protocol, Processor processor) {
        return this.handleArchive((EnterpriseArchive)((EnterpriseArchive)ShrinkWrap.create(EnterpriseArchive.class, (String)"test.ear")).addAsModule((Archive)applicationArchive), auxiliaryArchives, protocol, processor, null);
    }

    private Archive<?> handleArchive(EnterpriseArchive applicationArchive, Collection<Archive<?>> auxiliaryArchives, WebArchive protocol, Processor processor, TestDeployment testDeployment) {
        Map applicationArchiveWars = applicationArchive.getContent(Filters.include((String)".*\\.war"));
        if (applicationArchiveWars.size() == 1) {
            ArchivePath warPath = (ArchivePath)applicationArchiveWars.keySet().iterator().next();
            try {
                this.handleArchive((WebArchive)applicationArchive.getAsType(WebArchive.class, warPath), new ArrayList(), protocol, processor);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Can not manipulate war's that are not of type " + WebArchive.class, e);
            }
        } else if (applicationArchiveWars.size() > 1) {
            Archive archiveToTest = testDeployment.getArchiveForEnrichment();
            if (archiveToTest == null) {
                throw new UnsupportedOperationException("Multiple WebArchives found in " + applicationArchive.getName() + ". Can not determine which to enrich");
            }
            if (!archiveToTest.getName().endsWith(".war")) {
                throw new UnsupportedOperationException("Archive to test is not a WebArchive!");
            }
            this.handleArchive((WebArchive)archiveToTest.as(WebArchive.class), new ArrayList(), protocol, processor);
        } else {
            protocol.delete(ServletUtil.WEB_XML_PATH);
            applicationArchive.addAsModule(protocol.setWebXML((Asset)new StringAsset(WebUtils.createNewDescriptor().exportAsString())));
            if (applicationArchive.contains(ServletUtil.APPLICATION_XML_PATH)) {
                ApplicationDescriptor applicationXml = (ApplicationDescriptor)Descriptors.importAs(ApplicationDescriptor.class).from(applicationArchive.get(ServletUtil.APPLICATION_XML_PATH).getAsset().openStream());
                applicationXml.webModule(protocol.getName(), ServletUtil.calculateContextRoot(protocol.getName()));
                applicationArchive.delete(ServletUtil.APPLICATION_XML_PATH);
                applicationArchive.setApplicationXML((Asset)new StringAsset(applicationXml.exportAsString()));
            }
            processor.process((Archive<?>)protocol);
        }
        applicationArchive.addAsLibraries(auxiliaryArchives.toArray(new Archive[0]));
        return applicationArchive;
    }
}

