/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.arquillian.protocol.servlet;

import java.net.URI;
import org.jboss.arquillian.container.spi.client.protocol.metadata.HTTPContext;
import org.jboss.arquillian.container.spi.client.protocol.metadata.ProtocolMetaData;
import org.jboss.arquillian.container.spi.client.protocol.metadata.Servlet;
import org.jboss.arquillian.protocol.servlet.ServletProtocolConfiguration;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;

public final class ServletUtil {
    public static final ArchivePath WEB_XML_PATH = ArchivePaths.create((String)"WEB-INF/web.xml");
    public static final ArchivePath APPLICATION_XML_PATH = ArchivePaths.create((String)"META-INF/application.xml");

    private ServletUtil() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static URI determineBaseURI(ServletProtocolConfiguration config, ProtocolMetaData metaData, String servletName) {
        String address = config.getHost();
        Integer port = config.getPort();
        String contextRoot = null;
        if (!metaData.hasContext(HTTPContext.class)) throw new IllegalArgumentException("No " + HTTPContext.class.getName() + " found in " + ProtocolMetaData.class.getName() + ". " + "Servlet protocol can not be used");
        HTTPContext context = (HTTPContext)metaData.getContext(HTTPContext.class);
        Servlet servlet = context.getServletByName("ArquillianServletRunner");
        if (servlet == null) throw new IllegalArgumentException("ArquillianServletRunner not found. Could not determine ContextRoot from ProtocolMetadata, please contact DeployableContainer developer.");
        if (address == null) {
            address = context.getHost();
        }
        if (port == null) {
            port = context.getPort();
        }
        contextRoot = servlet.getContextRoot();
        return URI.create("http://" + address + ":" + port + contextRoot);
    }
}

