/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.auth;

import java.nio.charset.StandardCharsets;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import net.spy.memcached.MemcachedConnection;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.OperationFactory;
import net.spy.memcached.auth.AuthDescriptor;
import net.spy.memcached.compat.SpyThread;
import net.spy.memcached.compat.log.Level;
import net.spy.memcached.ops.OperationStatus;
import net.spy.memcached.ops.StoreOperation;
import net.spy.memcached.ops.StoreType;

public class AsciiAuthThread
extends SpyThread {
    public static final int AUTH_TOTAL_THRESHOLD = 250;
    private final MemcachedConnection conn;
    private final AuthDescriptor authDescriptor;
    private final OperationFactory opFact;
    private final MemcachedNode node;

    public AsciiAuthThread(MemcachedConnection c, OperationFactory o, AuthDescriptor a, MemcachedNode n) {
        this.conn = c;
        this.opFact = o;
        this.authDescriptor = a;
        this.node = n;
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Level level;
        long diff;
        final AtomicBoolean done = new AtomicBoolean();
        long start = System.nanoTime();
        final CountDownLatch latch = new CountDownLatch(1);
        NameCallback nameCallback = new NameCallback("memcached");
        PasswordCallback passwordCallback = new PasswordCallback("memcached", false);
        try {
            this.authDescriptor.getCallback().handle(new Callback[]{nameCallback, passwordCallback});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String credentials = nameCallback.getName() + ' ' + new String(passwordCallback.getPassword());
        StoreOperation op = this.opFact.store(StoreType.set, "ignore", 0, 0, credentials.getBytes(StandardCharsets.US_ASCII), new StoreOperation.Callback(){

            @Override
            public void receivedStatus(OperationStatus val) {
                if (val.isSuccess()) {
                    done.set(true);
                    AsciiAuthThread.this.node.authComplete();
                }
            }

            @Override
            public void gotData(String key, long cas) {
            }

            @Override
            public void complete() {
                latch.countDown();
            }
        });
        this.conn.insertOperation(this.node, op);
        try {
            if (!this.conn.isShutDown()) {
                latch.await();
            } else {
                done.set(true);
            }
            Thread.sleep(100L);
            diff = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
            level = diff >= 250L ? Level.WARN : Level.DEBUG;
        }
        catch (InterruptedException e) {
            Level level2;
            long diff2;
            try {
                Thread.currentThread().interrupt();
                if (op != null) {
                    op.cancel();
                }
                done.set(true);
                diff2 = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
                level2 = diff2 >= 250L ? Level.WARN : Level.DEBUG;
            }
            catch (Throwable throwable) {
                long diff3 = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start);
                Level level3 = diff3 >= 250L ? Level.WARN : Level.DEBUG;
                this.getLogger().log(level3, String.format("ASCII authentication step took %dms on %s", diff3, this.node.toString()));
                throw throwable;
            }
            this.getLogger().log(level2, String.format("ASCII authentication step took %dms on %s", diff2, this.node.toString()));
        }
        this.getLogger().log(level, String.format("ASCII authentication step took %dms on %s", diff, this.node.toString()));
    }
}

