/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.resp.logging;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import java.time.temporal.Temporal;
import javax.security.auth.Subject;
import net.jcip.annotations.Immutable;
import org.infinispan.security.Security;
import org.infinispan.server.core.transport.ConnectionMetadata;
import org.infinispan.server.resp.RespCommand;
import org.infinispan.server.resp.logging.RespAccessLogger;

@Immutable
public class AccessData {
    private final Temporal start;
    private final byte[][] keys;
    private final int requestBytes;
    private final int responseBytes;
    private final String principalName;
    private final String operation;
    private final Throwable throwable;

    private AccessData(Temporal start, byte[][] keys, int requestBytes, int responseBytes, String principalName, String operation, Throwable throwable) {
        this.start = start;
        this.keys = keys;
        this.requestBytes = requestBytes;
        this.responseBytes = responseBytes;
        this.principalName = principalName;
        this.operation = operation;
        this.throwable = throwable;
    }

    static AccessData create(ChannelHandlerContext ctx, RespCommand req, Temporal start, byte[][] keys, int requestBytes, int responseBytes, Throwable throwable) {
        ConnectionMetadata metadata = ConnectionMetadata.getInstance((Channel)ctx.channel());
        String principalName = Security.getSubjectUserPrincipalName((Subject)metadata.subject());
        return new AccessData(start, keys, requestBytes, responseBytes, principalName, req.getName(), throwable);
    }

    public void log(ChannelFuture future) {
        if (this.throwable == null) {
            RespAccessLogger.success(future, this);
        } else {
            RespAccessLogger.failure(future, this, this.throwable);
        }
    }

    public Temporal start() {
        return this.start;
    }

    public byte[][] keys() {
        return this.keys;
    }

    public int requestBytes() {
        return this.requestBytes;
    }

    public int responseBytes() {
        return this.responseBytes;
    }

    public String principalName() {
        return this.principalName;
    }

    public String operation() {
        return this.operation;
    }
}

