package javax.constraints;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public abstract class ProblemDelegator implements Problem {
	
	private final Problem problem;
	
	public ProblemDelegator(Problem problem) {
		if (problem == null)
			throw new RuntimeException("Invalid parameter for ProblemDelegator");
		this.problem = problem;
	}

	public String getAPIVersion() {
		return problem.getAPIVersion();
	}

	public String getImplVersion() {
		return problem.getImplVersion();
	}

	public String getName() {
		return problem.getName();
	}

	public void setName(String name) {
		problem.setName(name);
	}

	public Var add(Var var) {
		return problem.add(var);
	}

	public VarBool add(VarBool var) {
		return problem.add(var);
	}

	public Var add(String name, Var var) {
		return problem.add(name, var);
	}

	public VarReal add(VarReal var) {
		return problem.add(var);
	}

	public Constraint post(String name, String symbolicExpression) {
		return problem.post(name, symbolicExpression);
	}

	public void setDomainType(DomainType type) {
		problem.setDomainType(type);
	}

	public Var variable(String name, int min, int max) {
		return problem.variable(name, min, max);
	}
	
	public Var createVariable(String name, int min, int max) {
		return problem.createVariable(name, min, max);
	}

	public Var variable(String name, int min, int max, DomainType domainType) {
		return problem.variable(name, min, max, domainType);
	}

	public Var variable(int min, int max) {
		return problem.variable(min, max);
	}

	public VarBool variableBool(String name) {
		return problem.variableBool(name);
	}

	public VarBool variableBool() {
		return problem.variableBool();
	}

	public void setRealPrecision(double value) {
		problem.setRealPrecision(value);
	}

	public double getRealPrecision() {
		return problem.getRealPrecision();
	}

	public VarReal variableReal(String name, double min, double max) {
		return problem.variableReal(name, min, max);
	}

	public VarReal variableReal(String name) {
		return problem.variableReal(name);
	}

	public VarSet variableSet(String name, int min, int max) throws Exception {
		return problem.variableSet(name, min, max);
	}

	public VarSet variableSet(String name, int[] values) throws Exception {
		return problem.variableSet(name, values);
	}

	public VarSet variableSet(String name, Set set) throws Exception {
		return problem.variableSet(name, set);
	}

	public Var[] variableArray(String name, int min, int max, int size) {
		return problem.variableArray(name, min, max, size);
	}

	public Var variable(String name, int[] domain) {
		return problem.variable(name, domain);
	}

	public Var variable(int[] domain) {
		return problem.variable(domain);
	}

	public Var[] getVars() {
		return problem.getVars();
	}

	public VarBool[] getVarBools() {
		return problem.getVarBools();
	}

	public VarReal[] getVarReals() {
		return problem.getVarReals();
	}

	public VarReal[] getVarSets() {
		return problem.getVarSets();
	}

	public Var getVar(String name) {
		return problem.getVar(name);
	}

	public Constraint getConstraint(String name) {
		return problem.getConstraint(name);
	}

	public Constraint getFalseConstraint() {
		return problem.getFalseConstraint();
	}

	public Constraint getTrueConstraint() {
		return problem.getTrueConstraint();
	}

	public VarReal getVarReal(String name) {
		return problem.getVarReal(name);
	}

	public Var[] getVarArray(String name) {
		return problem.getVarArray(name);
	}

	public Constraint add(Constraint constraint) {
		return problem.add(constraint);
	}

	public Constraint[] getConstraints() {
		return problem.getConstraints();
	}

	public Constraint postElement(int[] array, Var indexVar, String oper,
			int value) {
		return problem.postElement(array, indexVar, oper, value);
	}

	public Constraint postElement(int[] array, Var indexVar, String oper,
			Var var) {
		return problem.postElement(array, indexVar, oper, var);
	}

	public Constraint postElement(Var[] vars, Var indexVar, String oper,
			int value) {
		return problem.postElement(vars, indexVar, oper, value);
	}

	public Constraint postElement(Var[] vars, Var indexVar, String oper, Var var) {
		return problem.postElement(vars, indexVar, oper, var);
	}

	public Constraint postElement(Set[] arrayOfSets, Var indexVar, String oper,
			VarSet var) {
		return problem.postElement(arrayOfSets, indexVar, oper, var);
	}

	public Constraint post(int[] array, Var[] vars, String oper, int value) {
		return problem.post(array, vars, oper, value);
	}

	public Constraint postLinear(int[] array, Var[] vars, String oper, int value) {
		return problem.postLinear(array, vars, oper, value);
	}

	public Constraint post(int[] array, Var[] vars, String oper, Var var) {
		return problem.post(array, vars, oper, var);
	}

	public Constraint postLinear(int[] array, Var[] vars, String oper, Var var) {
		return problem.postLinear(array, vars, oper, var);
	}

	public Constraint post(Var[] vars, String oper, int value) {
		return problem.post(vars, oper, value);
	}

	public Constraint postLinear(Var[] vars, String oper, int value) {
		return problem.postLinear(vars, oper, value);
	}

	public Constraint post(Var[] vars, String oper, Var var) {
		return problem.post(vars, oper, var);
	}

	public Constraint postLinear(Var[] vars, String oper, Var var) {
		return problem.postLinear(vars, oper, var);
	}

	public Constraint post(Var var1, Var var2, String oper, int value) {
		return problem.post(var1, var2, oper, value);
	}

	public Constraint post(Var var1, Var var2, String oper, Var var) {
		return problem.post(var1, var2, oper, var);
	}

	public Constraint post(Var var, String oper, int value) {
		return problem.post(var, oper, value);
	}

	public Constraint postLinear(Var var, String oper, int value) {
		return problem.postLinear(var, oper, value);
	}

	public Constraint post(Var var1, String oper, Var var2) {
		return problem.post(var1, oper, var2);
	}

	public Constraint postLinear(Var var1, String oper, Var var2) {
		return problem.postLinear(var1, oper, var2);
	}

	public Constraint linear(Var var, String oper, int value) {
		return problem.linear(var, oper, value);
	}

	public Constraint linear(Var var1, String oper, Var var2) {
		return problem.linear(var1, oper, var2);
	}

	public Var element(int[] array, Var indexVar) {
		return problem.element(array, indexVar);
	}

	public Var element(Var[] array, Var indexVar) {
		return problem.element(array, indexVar);
	}

	public Var min(Var[] arrayOfVariables) {
		return problem.min(arrayOfVariables);
	}

	public Var min(Var var1, Var var2) {
		return problem.min(var1, var2);
	}

	public Var max(Var[] arrayOfVariables) {
		return problem.max(arrayOfVariables);
	}

	public Var max(Var var1, Var var2) {
		return problem.max(var1, var2);
	}

	public Var sum(Var[] vars) {
		return problem.sum(vars);
	}

	public Var scalProd(int[] arrayOfValues, Var[] arrayOfVariables) {
		return problem.scalProd(arrayOfValues, arrayOfVariables);
	}

	public void post(Constraint c) {
		problem.post(c);
	}

	public Solver getSolver() {
		return problem.getSolver();
	}

	public void setSolver(Solver solver) {
		problem.setSolver(solver);
	}

	public void log(Var[] vars) {
		problem.log(vars);
	}

	public void log(String text) {
		problem.log(text);
	}

	public Constraint postAllDifferent(Var[] vars) {
		return problem.postAllDifferent(vars);
	}

	public Constraint postAllDifferent(List vars) {
		return problem.postAllDifferent(vars);
	}

	public Constraint postAllDiff(Var[] vars) {
		return problem.postAllDiff(vars);
	}

	public Constraint allDiff(Var[] vars) {
		return problem.allDiff(vars);
	}

	public Constraint postCardinality(Var[] vars, int cardValue, String oper,
			int value) {
		return problem.postCardinality(vars, cardValue, oper, value);
	}

	public Constraint postCardinality(Var[] vars, int cardValue, String oper,
			Var var) {
		return problem.postCardinality(vars, cardValue, oper, var);
	}

	public Constraint postCardinality(Var[] vars, Var cardVar, String oper,
			Var var) {
		return problem.postCardinality(vars, cardVar, oper, var);
	}

	public Constraint postCardinality(Var[] vars, Var cardVar, String oper,
			int value) {
		return problem.postCardinality(vars, cardVar, oper, value);
	}

	public Constraint postGlobalCardinality(Var[] vars, int[] values,
			Var[] cardinalityVars) {
		return problem.postGlobalCardinality(vars, values, cardinalityVars);
	}

	public Constraint postGlobalCardinality(Var[] vars, int[] values,
			int[] cardMin, int[] cardMax) {
		return problem.postGlobalCardinality(vars, values, cardMin, cardMax);
	}

	public Constraint postIfThen(Constraint constraint1, Constraint constraint2) {
		return problem.postIfThen(constraint1, constraint2);
	}

	public Constraint postAnd(Constraint c1, Constraint c2) {
		return problem.postAnd(c1, c2);
	}

	public Constraint postOr(Constraint c1, Constraint c2) {
		return problem.postOr(c1, c2);
	}

	public Constraint postMax(Var[] vars, String oper, Var var) {
		return problem.postMax(vars, oper, var);
	}

	public Constraint postMax(Var[] vars, String oper, int value) {
		return problem.postMax(vars, oper, value);
	}

	public Constraint postMin(Var[] vars, String oper, Var var) {
		return problem.postMin(vars, oper, var);
	}

	public Constraint postMin(Var[] vars, String oper, int value) {
		return problem.postMin(vars, oper, value);
	}

	public void loadFromXML(InputStream in) throws Exception {
		problem.loadFromXML(in);
	}

	public void storeToXML(OutputStream os, String comment) throws Exception {
		problem.storeToXML(os, comment);
	}

	public VarMatrix variableMatrix(String name, int min, int max, int rows,
			int columns) {
		return problem.variableMatrix(name, min, max, rows, columns);
	}

	public VarMatrix getVarMatrix(String name) {
		return problem.getVarMatrix(name);
	}

	public void add(VarString var) {
		problem.add(var);
	}

	public VarString[] getVarStrings() {
		return problem.getVarStrings();
	}

	public VarString getVarString(String name) {
		return problem.getVarString(name);
	}

	public VarString variableString(String name, String[] allStrings) {
		return problem.variableString(name, allStrings);
	}

	public Constraint post(VarString var, String oper, String value) {
		return problem.post(var, oper, value);
	}

	public Constraint linear(VarString var, String oper, String value) {
		return problem.linear(var, oper, value);
	}

	public Constraint post(VarString var1, String oper, VarString var2) {
		return problem.post(var1, oper, var2);
	}

	public Constraint post(VarList vars, String oper, int value) {
		return problem.post(vars, oper, value);
	}

	public Constraint post(VarList vars, String oper, Var var) {
		return problem.post(vars, oper, var);
	}

	public Var sum(VarList vars) {
		return problem.sum(vars);
	}

	public Constraint allDiff(VarList vars) {
		return problem.allDiff(vars);
	}

	public Var element(VarList list, Var indexVar) {
		return problem.element(list, indexVar);
	}

	public VarList variableList() {
		return problem.variableList();
	}

	public Constraint post(int[] array, VarList vars, String oper, int value) {
		return problem.post(array, vars, oper, value);
	}

	public Constraint postLinear(int[] array, VarList vars, String oper,
			int value) {
		return problem.postLinear(array, vars, oper, value);
	}

	public Var max(VarList listOfVariables) {
		return problem.max(listOfVariables);
	}

	public Var scalProd(int[] arrayOfValues, VarList listOfVariables) {
		return problem.scalProd(arrayOfValues, listOfVariables);
	}

	public void log(VarList vars) {
		problem.log(vars);
	}

	public Constraint postAllDifferent(VarList vars) {
		return problem.postAllDifferent(vars);
	}

	public Constraint postCardinality(VarList vars, int cardValue, String oper,
			int value) {
		return problem.postCardinality(vars, cardValue, oper, value);
	}

	public Constraint postCardinality(VarList vars, int cardValue, String oper,
			Var var) {
		return problem.postCardinality(vars, cardValue, oper, var);
	}

	public Constraint postCardinality(VarList vars, Var cardVar, String oper,
			Var var) {
		return problem.postCardinality(vars, cardVar, oper, var);
	}

	public Constraint postCardinality(VarList vars, Var cardVar, String oper,
			int value) {
		return problem.postCardinality(vars, cardVar, oper, value);
	}

	public Constraint postGlobalCardinality(VarList vars, int[] values,
			Var[] cardinalityVars) {
		return problem.postGlobalCardinality(vars, values, cardinalityVars);
	}

	public Constraint postGlobalCardinality(VarList vars, int[] values,
			int[] cardMin, int[] cardMax) {
		return problem.postGlobalCardinality(vars, values, cardMin, cardMax);
	}

	public VarSet element(Set<Integer>[] sets, Var indexVar) throws Exception {
		return problem.element(sets, indexVar);
	}

	public Var min(VarList listOfVariables) {
		return problem.min(listOfVariables);
	}

	public Constraint postAllDifferent(ArrayList<Var> vars) {
		return problem.postAllDifferent(vars);
	}

	public Constraint postAllDiff(ArrayList<Var> vars) {
		return problem.postAllDiff(vars);
	}	

	
}
