/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.internal.$processor$.encode;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleAnnotationValueVisitor7;
import org.immutables.value.internal.$guava$.base.$Optional;
import org.immutables.value.internal.$guava$.base.$Preconditions;
import org.immutables.value.internal.$guava$.collect.$ImmutableList;
import org.immutables.value.internal.$guava$.primitives.$Booleans;
import org.immutables.value.internal.$processor$.encode.$Mirrors;
import org.immutables.value.internal.$processor$.encode.$StandardNaming;

public class $NamingMirror
implements $Mirrors.Naming {
    public static final String QUALIFIED_NAME = "org.immutables.encode.Encoding.Naming";
    public static final String MIRROR_QUALIFIED_NAME = "org.immutables.value.internal.$processor$.encode.Mirrors.$Naming";
    private final AnnotationMirror annotationMirror;
    private final String value;
    private final boolean depluralize;
    private final $StandardNaming standard;

    public static String mirrorQualifiedName() {
        return QUALIFIED_NAME;
    }

    public static String qualifiedName() {
        return QUALIFIED_NAME;
    }

    public static String simpleName() {
        return "Naming";
    }

    public static boolean isPresent(Element annotatedElement) {
        for (AnnotationMirror annotationMirror : annotatedElement.getAnnotationMirrors()) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!element.getQualifiedName().contentEquals(QUALIFIED_NAME)) continue;
            return true;
        }
        return false;
    }

    public static $Optional<$NamingMirror> find(Element element) {
        return $NamingMirror.find(element.getAnnotationMirrors());
    }

    public static $Optional<$NamingMirror> find(Iterable<? extends AnnotationMirror> mirrors) {
        for (AnnotationMirror annotationMirror : mirrors) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!element.getQualifiedName().contentEquals(QUALIFIED_NAME)) continue;
            return $Optional.of(new $NamingMirror(annotationMirror));
        }
        return $Optional.absent();
    }

    public static $ImmutableList<$NamingMirror> fromAll(Iterable<? extends AnnotationMirror> mirrors) {
        $ImmutableList.Builder builder = $ImmutableList.builder();
        for (AnnotationMirror annotationMirror : mirrors) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            $Preconditions.checkState(element.getQualifiedName().contentEquals(QUALIFIED_NAME), "Supplied mirrors should all be of this annotation type");
            builder.add(new $NamingMirror(annotationMirror));
        }
        return builder.build();
    }

    public static $NamingMirror from(TypeElement element) {
        return new $NamingMirror(element);
    }

    public static $Optional<$NamingMirror> from(AnnotationMirror mirror) {
        return $NamingMirror.find(Collections.singleton(mirror));
    }

    private $NamingMirror(TypeElement defaultAnnotationElement) {
        $Preconditions.checkArgument(defaultAnnotationElement.getQualifiedName().contentEquals(QUALIFIED_NAME) || defaultAnnotationElement.getQualifiedName().contentEquals(MIRROR_QUALIFIED_NAME));
        this.annotationMirror = null;
        String value = null;
        boolean depluralize = false;
        $StandardNaming standard = null;
        for (ExecutableElement attributeElement$ : ElementFilter.methodsIn(defaultAnnotationElement.getEnclosedElements())) {
            AnnotationValue annotationValue$;
            String name$ = attributeElement$.getSimpleName().toString();
            if ("value".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Naming");
                }
                ValueExtractor valueExtractor$ = new ValueExtractor();
                annotationValue$.accept(valueExtractor$, null);
                value = valueExtractor$.get();
                continue;
            }
            if ("depluralize".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Naming");
                }
                DepluralizeExtractor depluralizeExtractor$ = new DepluralizeExtractor();
                annotationValue$.accept(depluralizeExtractor$, null);
                depluralize = depluralizeExtractor$.get();
                continue;
            }
            if (!"standard".equals(name$)) continue;
            annotationValue$ = attributeElement$.getDefaultValue();
            if (annotationValue$ == null) {
                throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Naming");
            }
            StandardExtractor standardExtractor$ = new StandardExtractor();
            annotationValue$.accept(standardExtractor$, null);
            standard = standardExtractor$.get();
        }
        this.value = $Preconditions.checkNotNull(value, "default attribute 'value'");
        this.depluralize = depluralize;
        this.standard = $Preconditions.checkNotNull(standard, "default attribute 'standard'");
    }

    private $NamingMirror(AnnotationMirror annotationMirror) {
        this.annotationMirror = annotationMirror;
        String value = null;
        boolean depluralize = false;
        $StandardNaming standard = null;
        Map<? extends ExecutableElement, ? extends AnnotationValue> attributeValues$ = annotationMirror.getElementValues();
        for (ExecutableElement attributeElement$ : ElementFilter.methodsIn(annotationMirror.getAnnotationType().asElement().getEnclosedElements())) {
            AnnotationValue annotationValue$;
            String name$ = attributeElement$.getSimpleName().toString();
            if ("value".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'value' attribute of @Naming");
                }
                ValueExtractor valueExtractor$ = new ValueExtractor();
                annotationValue$.accept(valueExtractor$, null);
                value = valueExtractor$.get();
                continue;
            }
            if ("depluralize".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'depluralize' attribute of @Naming");
                }
                DepluralizeExtractor depluralizeExtractor$ = new DepluralizeExtractor();
                annotationValue$.accept(depluralizeExtractor$, null);
                depluralize = depluralizeExtractor$.get();
                continue;
            }
            if (!"standard".equals(name$)) continue;
            annotationValue$ = attributeValues$.get(attributeElement$);
            if (annotationValue$ == null) {
                annotationValue$ = attributeElement$.getDefaultValue();
            }
            if (annotationValue$ == null) {
                throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'standard' attribute of @Naming");
            }
            StandardExtractor standardExtractor$ = new StandardExtractor();
            annotationValue$.accept(standardExtractor$, null);
            standard = standardExtractor$.get();
        }
        this.value = $Preconditions.checkNotNull(value, "value for 'value'");
        this.depluralize = depluralize;
        this.standard = $Preconditions.checkNotNull(standard, "value for 'standard'");
    }

    @Override
    public String value() {
        return this.value;
    }

    @Override
    public boolean depluralize() {
        return this.depluralize;
    }

    @Override
    public $StandardNaming standard() {
        return this.standard;
    }

    public AnnotationMirror getAnnotationMirror() {
        $Preconditions.checkState(this.annotationMirror != null, "this is default mirror without originating AnnotationMirror");
        return this.annotationMirror;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return $Mirrors.Naming.class;
    }

    @Override
    public int hashCode() {
        int h = 0;
        h += 127 * "value".hashCode() ^ this.value.hashCode();
        h += 127 * "depluralize".hashCode() ^ $Booleans.hashCode(this.depluralize);
        return h += 127 * "standard".hashCode() ^ this.standard.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof $NamingMirror) {
            $NamingMirror otherMirror = ($NamingMirror)other;
            return this.value.equals(otherMirror.value) && this.depluralize == otherMirror.depluralize && this.standard.equals((Object)otherMirror.standard);
        }
        return false;
    }

    @Override
    public String toString() {
        return "NamingMirror:" + this.annotationMirror;
    }

    private static class StandardExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        $StandardNaming value;

        private StandardExtractor() {
        }

        @Override
        public Void visitEnumConstant(VariableElement value, Void p) {
            this.value = $StandardNaming.valueOf(value.getSimpleName().toString());
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            $Preconditions.checkState(!array.isEmpty());
            array.get(0).accept(this, null);
            return null;
        }

        $StandardNaming get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'standard' in @org.immutables.encode.Encoding.Naming");
        }
    }

    private static class DepluralizeExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        boolean value;

        private DepluralizeExtractor() {
        }

        @Override
        public Void visitBoolean(boolean value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            $Preconditions.checkState(!array.isEmpty());
            array.get(0).accept(this, null);
            return null;
        }

        boolean get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'depluralize' in @org.immutables.encode.Encoding.Naming");
        }
    }

    private static class ValueExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private ValueExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            $Preconditions.checkState(!array.isEmpty());
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'value' in @org.immutables.encode.Encoding.Naming");
        }
    }
}

