/*
 * Decompiled with CFR 0.152.
 */
package org.immutables.value.processor.encode;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleAnnotationValueVisitor7;
import org.immutables.value.processor.encode.Mirrors;

public class EncElementMirror
implements Mirrors.EncElement {
    public static final String QUALIFIED_NAME = "org.immutables.encode.EncodingMetadata.Element";
    public static final String MIRROR_QUALIFIED_NAME = "org.immutables.value.processor.encode.Mirrors.EncElement";
    private final AnnotationMirror annotationMirror;
    private final String name;
    private final String type;
    private final String naming;
    private final String stdNaming;
    private final String[] tags;
    private final String[] typeParams;
    private final String[] params;
    private final String[] thrown;
    private final String[] annotations;
    private final String[] doc;
    private final String code;

    public static String mirrorQualifiedName() {
        return QUALIFIED_NAME;
    }

    public static String qualifiedName() {
        return QUALIFIED_NAME;
    }

    public static String simpleName() {
        return "Element";
    }

    public static boolean isPresent(Element annotatedElement) {
        for (AnnotationMirror annotationMirror : annotatedElement.getAnnotationMirrors()) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!element.getQualifiedName().contentEquals(QUALIFIED_NAME)) continue;
            return true;
        }
        return false;
    }

    public static Optional<EncElementMirror> find(Element element) {
        return EncElementMirror.find(element.getAnnotationMirrors());
    }

    public static Optional<EncElementMirror> find(Iterable<? extends AnnotationMirror> mirrors) {
        for (AnnotationMirror annotationMirror : mirrors) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!element.getQualifiedName().contentEquals(QUALIFIED_NAME)) continue;
            return Optional.of((Object)new EncElementMirror(annotationMirror));
        }
        return Optional.absent();
    }

    public static ImmutableList<EncElementMirror> fromAll(Iterable<? extends AnnotationMirror> mirrors) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (AnnotationMirror annotationMirror : mirrors) {
            TypeElement element = (TypeElement)annotationMirror.getAnnotationType().asElement();
            Preconditions.checkState((boolean)element.getQualifiedName().contentEquals(QUALIFIED_NAME), (Object)"Supplied mirrors should all be of this annotation type");
            builder.add((Object)new EncElementMirror(annotationMirror));
        }
        return builder.build();
    }

    public static EncElementMirror from(TypeElement element) {
        return new EncElementMirror(element);
    }

    public static Optional<EncElementMirror> from(AnnotationMirror mirror) {
        return EncElementMirror.find(Collections.singleton(mirror));
    }

    private EncElementMirror(TypeElement defaultAnnotationElement) {
        Preconditions.checkArgument((defaultAnnotationElement.getQualifiedName().contentEquals(QUALIFIED_NAME) || defaultAnnotationElement.getQualifiedName().contentEquals(MIRROR_QUALIFIED_NAME) ? 1 : 0) != 0);
        this.annotationMirror = null;
        String name = null;
        String type = null;
        String naming = null;
        String stdNaming = null;
        String[] tags = null;
        String[] typeParams = null;
        String[] params = null;
        String[] thrown = null;
        String[] annotations = null;
        String[] doc = null;
        String code = null;
        for (ExecutableElement attributeElement$ : ElementFilter.methodsIn(defaultAnnotationElement.getEnclosedElements())) {
            AnnotationValue annotationValue$;
            String name$ = attributeElement$.getSimpleName().toString();
            if ("name".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Element");
                }
                NameExtractor nameExtractor$ = new NameExtractor();
                annotationValue$.accept(nameExtractor$, null);
                name = nameExtractor$.get();
                continue;
            }
            if ("type".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Element");
                }
                TypeExtractor typeExtractor$ = new TypeExtractor();
                annotationValue$.accept(typeExtractor$, null);
                type = typeExtractor$.get();
                continue;
            }
            if ("naming".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Element");
                }
                NamingExtractor namingExtractor$ = new NamingExtractor();
                annotationValue$.accept(namingExtractor$, null);
                naming = namingExtractor$.get();
                continue;
            }
            if ("stdNaming".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Element");
                }
                StdNamingExtractor stdNamingExtractor$ = new StdNamingExtractor();
                annotationValue$.accept(stdNamingExtractor$, null);
                stdNaming = stdNamingExtractor$.get();
                continue;
            }
            if ("tags".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Element");
                }
                TagsExtractor tagsExtractor$ = new TagsExtractor();
                annotationValue$.accept(tagsExtractor$, null);
                tags = tagsExtractor$.get();
                continue;
            }
            if ("typeParams".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Element");
                }
                TypeParamsExtractor typeParamsExtractor$ = new TypeParamsExtractor();
                annotationValue$.accept(typeParamsExtractor$, null);
                typeParams = typeParamsExtractor$.get();
                continue;
            }
            if ("params".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Element");
                }
                ParamsExtractor paramsExtractor$ = new ParamsExtractor();
                annotationValue$.accept(paramsExtractor$, null);
                params = paramsExtractor$.get();
                continue;
            }
            if ("thrown".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Element");
                }
                ThrownExtractor thrownExtractor$ = new ThrownExtractor();
                annotationValue$.accept(thrownExtractor$, null);
                thrown = thrownExtractor$.get();
                continue;
            }
            if ("annotations".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Element");
                }
                AnnotationsExtractor annotationsExtractor$ = new AnnotationsExtractor();
                annotationValue$.accept(annotationsExtractor$, null);
                annotations = annotationsExtractor$.get();
                continue;
            }
            if ("doc".equals(name$)) {
                annotationValue$ = attributeElement$.getDefaultValue();
                if (annotationValue$ == null) {
                    throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Element");
                }
                DocExtractor docExtractor$ = new DocExtractor();
                annotationValue$.accept(docExtractor$, null);
                doc = docExtractor$.get();
                continue;
            }
            if (!"code".equals(name$)) continue;
            annotationValue$ = attributeElement$.getDefaultValue();
            if (annotationValue$ == null) {
                throw new IllegalStateException("All annotation attributes should have default value to create mirror of @Element");
            }
            CodeExtractor codeExtractor$ = new CodeExtractor();
            annotationValue$.accept(codeExtractor$, null);
            code = codeExtractor$.get();
        }
        this.name = (String)Preconditions.checkNotNull(name, (Object)"default attribute 'name'");
        this.type = (String)Preconditions.checkNotNull(type, (Object)"default attribute 'type'");
        this.naming = (String)Preconditions.checkNotNull(naming, (Object)"default attribute 'naming'");
        this.stdNaming = (String)Preconditions.checkNotNull(stdNaming, (Object)"default attribute 'stdNaming'");
        this.tags = (String[])Preconditions.checkNotNull(tags, (Object)"default attribute 'tags'");
        this.typeParams = (String[])Preconditions.checkNotNull(typeParams, (Object)"default attribute 'typeParams'");
        this.params = (String[])Preconditions.checkNotNull(params, (Object)"default attribute 'params'");
        this.thrown = (String[])Preconditions.checkNotNull(thrown, (Object)"default attribute 'thrown'");
        this.annotations = (String[])Preconditions.checkNotNull(annotations, (Object)"default attribute 'annotations'");
        this.doc = (String[])Preconditions.checkNotNull(doc, (Object)"default attribute 'doc'");
        this.code = (String)Preconditions.checkNotNull(code, (Object)"default attribute 'code'");
    }

    private EncElementMirror(AnnotationMirror annotationMirror) {
        this.annotationMirror = annotationMirror;
        String name = null;
        String type = null;
        String naming = null;
        String stdNaming = null;
        String[] tags = null;
        String[] typeParams = null;
        String[] params = null;
        String[] thrown = null;
        String[] annotations = null;
        String[] doc = null;
        String code = null;
        Map<? extends ExecutableElement, ? extends AnnotationValue> attributeValues$ = annotationMirror.getElementValues();
        for (ExecutableElement attributeElement$ : ElementFilter.methodsIn(annotationMirror.getAnnotationType().asElement().getEnclosedElements())) {
            AnnotationValue annotationValue$;
            String name$ = attributeElement$.getSimpleName().toString();
            if ("name".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'name' attribute of @Element");
                }
                NameExtractor nameExtractor$ = new NameExtractor();
                annotationValue$.accept(nameExtractor$, null);
                name = nameExtractor$.get();
                continue;
            }
            if ("type".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'type' attribute of @Element");
                }
                TypeExtractor typeExtractor$ = new TypeExtractor();
                annotationValue$.accept(typeExtractor$, null);
                type = typeExtractor$.get();
                continue;
            }
            if ("naming".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'naming' attribute of @Element");
                }
                NamingExtractor namingExtractor$ = new NamingExtractor();
                annotationValue$.accept(namingExtractor$, null);
                naming = namingExtractor$.get();
                continue;
            }
            if ("stdNaming".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'stdNaming' attribute of @Element");
                }
                StdNamingExtractor stdNamingExtractor$ = new StdNamingExtractor();
                annotationValue$.accept(stdNamingExtractor$, null);
                stdNaming = stdNamingExtractor$.get();
                continue;
            }
            if ("tags".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'tags' attribute of @Element");
                }
                TagsExtractor tagsExtractor$ = new TagsExtractor();
                annotationValue$.accept(tagsExtractor$, null);
                tags = tagsExtractor$.get();
                continue;
            }
            if ("typeParams".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'typeParams' attribute of @Element");
                }
                TypeParamsExtractor typeParamsExtractor$ = new TypeParamsExtractor();
                annotationValue$.accept(typeParamsExtractor$, null);
                typeParams = typeParamsExtractor$.get();
                continue;
            }
            if ("params".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'params' attribute of @Element");
                }
                ParamsExtractor paramsExtractor$ = new ParamsExtractor();
                annotationValue$.accept(paramsExtractor$, null);
                params = paramsExtractor$.get();
                continue;
            }
            if ("thrown".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'thrown' attribute of @Element");
                }
                ThrownExtractor thrownExtractor$ = new ThrownExtractor();
                annotationValue$.accept(thrownExtractor$, null);
                thrown = thrownExtractor$.get();
                continue;
            }
            if ("annotations".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'annotations' attribute of @Element");
                }
                AnnotationsExtractor annotationsExtractor$ = new AnnotationsExtractor();
                annotationValue$.accept(annotationsExtractor$, null);
                annotations = annotationsExtractor$.get();
                continue;
            }
            if ("doc".equals(name$)) {
                annotationValue$ = attributeValues$.get(attributeElement$);
                if (annotationValue$ == null) {
                    annotationValue$ = attributeElement$.getDefaultValue();
                }
                if (annotationValue$ == null) {
                    throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'doc' attribute of @Element");
                }
                DocExtractor docExtractor$ = new DocExtractor();
                annotationValue$.accept(docExtractor$, null);
                doc = docExtractor$.get();
                continue;
            }
            if (!"code".equals(name$)) continue;
            annotationValue$ = attributeValues$.get(attributeElement$);
            if (annotationValue$ == null) {
                annotationValue$ = attributeElement$.getDefaultValue();
            }
            if (annotationValue$ == null) {
                throw new IllegalStateException("Annotation mirror contains no value (neither default) for 'code' attribute of @Element");
            }
            CodeExtractor codeExtractor$ = new CodeExtractor();
            annotationValue$.accept(codeExtractor$, null);
            code = codeExtractor$.get();
        }
        this.name = (String)Preconditions.checkNotNull(name, (Object)"value for 'name'");
        this.type = (String)Preconditions.checkNotNull(type, (Object)"value for 'type'");
        this.naming = (String)Preconditions.checkNotNull(naming, (Object)"value for 'naming'");
        this.stdNaming = (String)Preconditions.checkNotNull(stdNaming, (Object)"value for 'stdNaming'");
        this.tags = (String[])Preconditions.checkNotNull(tags, (Object)"value for 'tags'");
        this.typeParams = (String[])Preconditions.checkNotNull(typeParams, (Object)"value for 'typeParams'");
        this.params = (String[])Preconditions.checkNotNull(params, (Object)"value for 'params'");
        this.thrown = (String[])Preconditions.checkNotNull(thrown, (Object)"value for 'thrown'");
        this.annotations = (String[])Preconditions.checkNotNull(annotations, (Object)"value for 'annotations'");
        this.doc = (String[])Preconditions.checkNotNull(doc, (Object)"value for 'doc'");
        this.code = (String)Preconditions.checkNotNull(code, (Object)"value for 'code'");
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String naming() {
        return this.naming;
    }

    @Override
    public String stdNaming() {
        return this.stdNaming;
    }

    @Override
    public String[] tags() {
        return (String[])this.tags.clone();
    }

    @Override
    public String[] typeParams() {
        return (String[])this.typeParams.clone();
    }

    @Override
    public String[] params() {
        return (String[])this.params.clone();
    }

    @Override
    public String[] thrown() {
        return (String[])this.thrown.clone();
    }

    @Override
    public String[] annotations() {
        return (String[])this.annotations.clone();
    }

    @Override
    public String[] doc() {
        return (String[])this.doc.clone();
    }

    @Override
    public String code() {
        return this.code;
    }

    public AnnotationMirror getAnnotationMirror() {
        Preconditions.checkState((this.annotationMirror != null ? 1 : 0) != 0, (Object)"this is default mirror without originating AnnotationMirror");
        return this.annotationMirror;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return Mirrors.EncElement.class;
    }

    @Override
    public int hashCode() {
        int h = 0;
        h += 127 * "name".hashCode() ^ this.name.hashCode();
        h += 127 * "type".hashCode() ^ this.type.hashCode();
        h += 127 * "naming".hashCode() ^ this.naming.hashCode();
        h += 127 * "stdNaming".hashCode() ^ this.stdNaming.hashCode();
        h += 127 * "tags".hashCode() ^ Arrays.hashCode(this.tags);
        h += 127 * "typeParams".hashCode() ^ Arrays.hashCode(this.typeParams);
        h += 127 * "params".hashCode() ^ Arrays.hashCode(this.params);
        h += 127 * "thrown".hashCode() ^ Arrays.hashCode(this.thrown);
        h += 127 * "annotations".hashCode() ^ Arrays.hashCode(this.annotations);
        h += 127 * "doc".hashCode() ^ Arrays.hashCode(this.doc);
        return h += 127 * "code".hashCode() ^ this.code.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof EncElementMirror) {
            EncElementMirror otherMirror = (EncElementMirror)other;
            return this.name.equals(otherMirror.name) && this.type.equals(otherMirror.type) && this.naming.equals(otherMirror.naming) && this.stdNaming.equals(otherMirror.stdNaming) && Arrays.equals(this.tags, otherMirror.tags) && Arrays.equals(this.typeParams, otherMirror.typeParams) && Arrays.equals(this.params, otherMirror.params) && Arrays.equals(this.thrown, otherMirror.thrown) && Arrays.equals(this.annotations, otherMirror.annotations) && Arrays.equals(this.doc, otherMirror.doc) && this.code.equals(otherMirror.code);
        }
        return false;
    }

    @Override
    public String toString() {
        return "EncElementMirror:" + this.annotationMirror;
    }

    private static class NameExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private NameExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'name' in @org.immutables.encode.EncodingMetadata.Element");
        }
    }

    private static class TypeExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private TypeExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'type' in @org.immutables.encode.EncodingMetadata.Element");
        }
    }

    private static class NamingExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private NamingExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'naming' in @org.immutables.encode.EncodingMetadata.Element");
        }
    }

    private static class StdNamingExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private StdNamingExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'stdNaming' in @org.immutables.encode.EncodingMetadata.Element");
        }
    }

    private static class TagsExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String[] values;
        int position;

        private TagsExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.values[this.position++] = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            this.values = new String[array.size()];
            Verify.verify((this.position == 0 ? 1 : 0) != 0);
            for (AnnotationValue annotationValue : array) {
                annotationValue.accept(this, null);
            }
            return null;
        }

        String[] get() {
            return this.values;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'tags' in @org.immutables.encode.EncodingMetadata.Element");
        }
    }

    private static class TypeParamsExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String[] values;
        int position;

        private TypeParamsExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.values[this.position++] = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            this.values = new String[array.size()];
            Verify.verify((this.position == 0 ? 1 : 0) != 0);
            for (AnnotationValue annotationValue : array) {
                annotationValue.accept(this, null);
            }
            return null;
        }

        String[] get() {
            return this.values;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'typeParams' in @org.immutables.encode.EncodingMetadata.Element");
        }
    }

    private static class ParamsExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String[] values;
        int position;

        private ParamsExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.values[this.position++] = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            this.values = new String[array.size()];
            Verify.verify((this.position == 0 ? 1 : 0) != 0);
            for (AnnotationValue annotationValue : array) {
                annotationValue.accept(this, null);
            }
            return null;
        }

        String[] get() {
            return this.values;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'params' in @org.immutables.encode.EncodingMetadata.Element");
        }
    }

    private static class ThrownExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String[] values;
        int position;

        private ThrownExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.values[this.position++] = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            this.values = new String[array.size()];
            Verify.verify((this.position == 0 ? 1 : 0) != 0);
            for (AnnotationValue annotationValue : array) {
                annotationValue.accept(this, null);
            }
            return null;
        }

        String[] get() {
            return this.values;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'thrown' in @org.immutables.encode.EncodingMetadata.Element");
        }
    }

    private static class AnnotationsExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String[] values;
        int position;

        private AnnotationsExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.values[this.position++] = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            this.values = new String[array.size()];
            Verify.verify((this.position == 0 ? 1 : 0) != 0);
            for (AnnotationValue annotationValue : array) {
                annotationValue.accept(this, null);
            }
            return null;
        }

        String[] get() {
            return this.values;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'annotations' in @org.immutables.encode.EncodingMetadata.Element");
        }
    }

    private static class DocExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String[] values;
        int position;

        private DocExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.values[this.position++] = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            this.values = new String[array.size()];
            Verify.verify((this.position == 0 ? 1 : 0) != 0);
            for (AnnotationValue annotationValue : array) {
                annotationValue.accept(this, null);
            }
            return null;
        }

        String[] get() {
            return this.values;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'doc' in @org.immutables.encode.EncodingMetadata.Element");
        }
    }

    private static class CodeExtractor
    extends SimpleAnnotationValueVisitor7<Void, Void> {
        String value;

        private CodeExtractor() {
        }

        @Override
        public Void visitString(String value, Void p) {
            this.value = value;
            return null;
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> array, Void p) {
            Preconditions.checkState((!array.isEmpty() ? 1 : 0) != 0);
            array.get(0).accept(this, null);
            return null;
        }

        String get() {
            return this.value;
        }

        @Override
        protected Void defaultAction(Object o, Void p) {
            throw new IllegalStateException("Incompatible annotation content of attribute 'code' in @org.immutables.encode.EncodingMetadata.Element");
        }
    }
}

