/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.model.spi;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.hibernate.search.mapper.pojo.model.spi.AbstractPojoGenericTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.GenericContextAwarePojoPropertyModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoGenericTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoPropertyModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.util.common.reflect.impl.GenericTypeContext;
import org.hibernate.search.util.common.reflect.impl.ReflectionUtils;

public final class GenericContextAwarePojoGenericTypeModel<T>
extends AbstractPojoGenericTypeModel<T>
implements PojoGenericTypeModel<T> {
    private final Helper helper;
    private final GenericTypeContext genericTypeContext;
    private final Map<Object, PojoPropertyModel<?>> genericPropertyCache = new HashMap();

    private GenericContextAwarePojoGenericTypeModel(Helper helper, GenericTypeContext genericTypeContext) {
        super(helper.rawTypeModel(ReflectionUtils.getRawType((Type)genericTypeContext.getResolvedType())));
        this.helper = helper;
        this.genericTypeContext = genericTypeContext;
    }

    @Override
    public String name() {
        return this.genericTypeContext.getResolvedType().getTypeName();
    }

    @Override
    public PojoPropertyModel<?> property(String propertyName) {
        return this.wrapProperty(super.property(propertyName));
    }

    @Override
    public Optional<PojoGenericTypeModel<?>> typeArgument(Class<?> rawSuperType, int typeParameterIndex) {
        return this.genericTypeContext.resolveTypeArgument(rawSuperType, typeParameterIndex).map(type -> new GenericContextAwarePojoGenericTypeModel<T>(this.helper, new GenericTypeContext(this.genericTypeContext.getDeclaringContext(), type)));
    }

    @Override
    public Optional<PojoGenericTypeModel<?>> arrayElementType() {
        return this.genericTypeContext.resolveArrayElementType().map(type -> new GenericContextAwarePojoGenericTypeModel<T>(this.helper, new GenericTypeContext(this.genericTypeContext.getDeclaringContext(), type)));
    }

    private <U> PojoPropertyModel<? extends U> wrapProperty(PojoPropertyModel<U> rawPropertyModel) {
        Object cacheKey = this.helper.propertyCacheKey(rawPropertyModel);
        PojoPropertyModel<?> cached = this.genericPropertyCache.get(cacheKey);
        if (cached != null) {
            return cached;
        }
        Type propertyType = this.helper.propertyGenericType(rawPropertyModel);
        GenericTypeContext propertyGenericTypeContext = new GenericTypeContext(this.genericTypeContext, propertyType);
        GenericContextAwarePojoGenericTypeModel<T> genericPropertyTypeModel = new GenericContextAwarePojoGenericTypeModel<T>(this.helper, propertyGenericTypeContext);
        GenericContextAwarePojoPropertyModel<U> propertyModel = new GenericContextAwarePojoPropertyModel<U>(rawPropertyModel, genericPropertyTypeModel);
        this.genericPropertyCache.put(cacheKey, propertyModel);
        return propertyModel;
    }

    public static class RawTypeDeclaringContext<T> {
        private final Helper helper;
        private final GenericTypeContext genericTypeContext;

        public RawTypeDeclaringContext(Helper helper, Class<T> rawType) {
            this.helper = helper;
            this.genericTypeContext = new GenericTypeContext(rawType);
        }

        public <U> PojoGenericTypeModel<U> createGenericTypeModel(Class<U> declaredType) {
            return this.createGenericTypeModel((Type)declaredType);
        }

        public PojoGenericTypeModel<?> createGenericTypeModel(Type declaredType) {
            return new GenericContextAwarePojoGenericTypeModel(this.helper, new GenericTypeContext(this.genericTypeContext, declaredType));
        }
    }

    public static interface Helper {
        public <T> PojoRawTypeModel<T> rawTypeModel(Class<T> var1);

        public Object propertyCacheKey(PojoPropertyModel<?> var1);

        public Type propertyGenericType(PojoPropertyModel<?> var1);
    }
}

