/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.model.additionalmetadata.building.impl;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.engine.mapper.mapping.building.spi.TypeMetadataContributorProvider;
import org.hibernate.search.engine.reporting.spi.FailureCollector;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoTypeMetadataContributor;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.building.impl.PojoTypeAdditionalMetadataBuilder;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.impl.PojoTypeAdditionalMetadata;
import org.hibernate.search.mapper.pojo.model.additionalmetadata.impl.PojoValueAdditionalMetadata;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPath;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathPropertyNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathTypeNode;
import org.hibernate.search.mapper.pojo.model.path.impl.BoundPojoModelPathValueNode;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.model.spi.PojoTypeModel;

public class PojoTypeAdditionalMetadataProvider {
    private final BeanResolver beanResolver;
    private final FailureCollector failureCollector;
    private final TypeMetadataContributorProvider<PojoTypeMetadataContributor> modelContributorProvider;
    private final Map<PojoRawTypeModel<?>, PojoTypeAdditionalMetadata> cache = new HashMap();

    public PojoTypeAdditionalMetadataProvider(BeanResolver beanResolver, FailureCollector failureCollector, TypeMetadataContributorProvider<PojoTypeMetadataContributor> modelContributorProvider) {
        this.beanResolver = beanResolver;
        this.failureCollector = failureCollector;
        this.modelContributorProvider = modelContributorProvider;
    }

    public PojoTypeAdditionalMetadata get(PojoRawTypeModel<?> typeModel) {
        return this.cache.computeIfAbsent(typeModel, this::createTypeAdditionalMetadata);
    }

    public PojoValueAdditionalMetadata get(BoundPojoModelPathValueNode<?, ?, ?> valueNode) {
        BoundPojoModelPath propertyNode = valueNode.getParent();
        BoundPojoModelPath typeNode = ((BoundPojoModelPathPropertyNode)propertyNode).getParent();
        PojoTypeModel typeModel = ((BoundPojoModelPathTypeNode)typeNode).getTypeModel();
        return this.get(typeModel.rawType()).getPropertyAdditionalMetadata(((BoundPojoModelPathPropertyNode)propertyNode).getPropertyModel().name()).getValueAdditionalMetadata(valueNode.getExtractorPath());
    }

    private PojoTypeAdditionalMetadata createTypeAdditionalMetadata(PojoRawTypeModel<?> typeModel) {
        PojoTypeAdditionalMetadataBuilder builder = new PojoTypeAdditionalMetadataBuilder(this.beanResolver, this.failureCollector, typeModel);
        for (PojoTypeMetadataContributor contributor : this.modelContributorProvider.get(typeModel)) {
            contributor.contributeAdditionalMetadata(builder);
        }
        return builder.build();
    }
}

