/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.builtin.impl;

import org.hibernate.search.engine.cfg.spi.ValidateUtils;
import org.hibernate.search.mapper.pojo.bridge.ValueBridge;
import org.hibernate.search.mapper.pojo.bridge.binding.ValueBindingContext;
import org.hibernate.search.mapper.pojo.bridge.mapping.programmatic.ValueBinder;
import org.hibernate.search.mapper.pojo.bridge.runtime.ValueBridgeFromIndexedValueContext;
import org.hibernate.search.mapper.pojo.bridge.runtime.ValueBridgeToIndexedValueContext;

public final class DefaultEnumValueBridge<V extends Enum<V>>
implements ValueBridge<V, String> {
    private final Class<V> enumType;

    private DefaultEnumValueBridge(Class<V> enumType) {
        this.enumType = enumType;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.enumType.getName() + "]";
    }

    @Override
    public String toIndexedValue(V value, ValueBridgeToIndexedValueContext context) {
        return value == null ? null : ((Enum)value).name();
    }

    @Override
    public V fromIndexedValue(String value, ValueBridgeFromIndexedValueContext context) {
        return value == null ? null : (V)Enum.valueOf(this.enumType, value);
    }

    @Override
    public String parse(String value) {
        ValidateUtils.validateEnum((String)value, this.enumType);
        return value;
    }

    @Override
    public boolean isCompatibleWith(ValueBridge<?, ?> other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        DefaultEnumValueBridge castedOther = (DefaultEnumValueBridge)other;
        return this.enumType.equals(castedOther.enumType);
    }

    public static class Binder
    implements ValueBinder {
        @Override
        public void bind(ValueBindingContext<?> context) {
            this.doBind(context, context.bridgedElement().rawType());
        }

        private <V extends Enum<V>> void doBind(ValueBindingContext<?> context, Class<V> enumType) {
            context.bridge(enumType, new DefaultEnumValueBridge(enumType));
        }
    }
}

