/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.builtin.impl;

import org.hibernate.search.engine.cfg.spi.ValidateUtils;
import org.hibernate.search.mapper.pojo.bridge.ValueBridge;
import org.hibernate.search.mapper.pojo.bridge.runtime.ValueBridgeFromIndexedValueContext;
import org.hibernate.search.mapper.pojo.bridge.runtime.ValueBridgeToIndexedValueContext;

public final class DefaultCharacterValueBridge
implements ValueBridge<Character, String> {
    public String toString() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String toIndexedValue(Character value, ValueBridgeToIndexedValueContext context) {
        return value == null ? null : Character.toString(value.charValue());
    }

    @Override
    public Character fromIndexedValue(String value, ValueBridgeFromIndexedValueContext context) {
        return value == null || value.isEmpty() ? null : Character.valueOf(value.charAt(0));
    }

    @Override
    public String parse(String value) {
        ValidateUtils.validateCharacter((String)value);
        return value;
    }

    @Override
    public boolean isCompatibleWith(ValueBridge<?, ?> other) {
        return this.getClass().equals(other.getClass());
    }
}

