/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.work.impl;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.hibernate.search.engine.backend.work.execution.spi.IndexIndexingPlanExecutionReport;
import org.hibernate.search.mapper.orm.common.EntityReference;
import org.hibernate.search.mapper.orm.work.SearchIndexingPlanExecutionReport;
import org.hibernate.search.util.common.AssertionFailure;

public class SearchIndexingPlanExecutionReportImpl
implements SearchIndexingPlanExecutionReport {
    private Throwable throwable;
    private List<EntityReference> failingEntities;

    public static SearchIndexingPlanExecutionReport from(IndexIndexingPlanExecutionReport<EntityReference> indexReport) {
        Throwable throwable = indexReport.throwable().orElse(null);
        List failingEntities = indexReport.failingEntityReferences();
        if (throwable == null && !failingEntities.isEmpty()) {
            throwable = new AssertionFailure("Unknown throwable: missing throwable when reporting the failure.");
        }
        return new SearchIndexingPlanExecutionReportImpl(throwable, failingEntities);
    }

    private SearchIndexingPlanExecutionReportImpl(Throwable throwable, List<EntityReference> failingEntities) {
        this.throwable = throwable;
        this.failingEntities = failingEntities == null ? Collections.emptyList() : Collections.unmodifiableList(failingEntities);
    }

    @Override
    public Optional<Throwable> throwable() {
        return Optional.ofNullable(this.throwable);
    }

    @Override
    public List<EntityReference> failingEntities() {
        return this.failingEntities;
    }
}

