/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.search.loading.context.impl;

import java.lang.invoke.MethodHandles;
import java.util.Set;
import javax.persistence.EntityGraph;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.graph.GraphSemantic;
import org.hibernate.graph.RootGraph;
import org.hibernate.search.engine.backend.common.spi.DocumentReferenceConverter;
import org.hibernate.search.engine.search.loading.context.spi.LoadingContext;
import org.hibernate.search.engine.search.loading.context.spi.LoadingContextBuilder;
import org.hibernate.search.engine.search.loading.spi.DefaultProjectionHitMapper;
import org.hibernate.search.engine.search.loading.spi.EntityLoader;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;
import org.hibernate.search.mapper.orm.common.EntityReference;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.scope.impl.HibernateOrmScopeIndexedTypeContext;
import org.hibernate.search.mapper.orm.search.loading.EntityLoadingCacheLookupStrategy;
import org.hibernate.search.mapper.orm.search.loading.dsl.SearchLoadingOptionsStep;
import org.hibernate.search.mapper.orm.search.loading.impl.EntityGraphHint;
import org.hibernate.search.mapper.orm.search.loading.impl.EntityLoaderBuilder;
import org.hibernate.search.mapper.orm.search.loading.impl.HibernateOrmLoadingMappingContext;
import org.hibernate.search.mapper.orm.search.loading.impl.HibernateOrmLoadingSessionContext;
import org.hibernate.search.mapper.orm.search.loading.impl.MutableEntityLoadingOptions;
import org.hibernate.search.util.common.impl.Contracts;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class HibernateOrmLoadingContext<E>
implements LoadingContext<EntityReference, E> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final SessionImplementor sessionImplementor;
    private final DocumentReferenceConverter<EntityReference> referenceHitMapper;
    private final EntityLoader<EntityReference, ? extends E> entityLoader;
    private final MutableEntityLoadingOptions loadingOptions;

    private HibernateOrmLoadingContext(SessionImplementor sessionImplementor, DocumentReferenceConverter<EntityReference> referenceHitMapper, EntityLoader<EntityReference, ? extends E> entityLoader, MutableEntityLoadingOptions loadingOptions) {
        this.sessionImplementor = sessionImplementor;
        this.referenceHitMapper = referenceHitMapper;
        this.entityLoader = entityLoader;
        this.loadingOptions = loadingOptions;
    }

    public ProjectionHitMapper<EntityReference, E> createProjectionHitMapper() {
        try {
            this.sessionImplementor.checkOpen();
        }
        catch (IllegalStateException e) {
            throw log.hibernateSessionIsClosed(e);
        }
        return new DefaultProjectionHitMapper(this.referenceHitMapper, this.entityLoader);
    }

    public SessionImplementor sessionImplementor() {
        return this.sessionImplementor;
    }

    public MutableEntityLoadingOptions loadingOptions() {
        return this.loadingOptions;
    }

    public static final class Builder<E>
    implements LoadingContextBuilder<EntityReference, E, SearchLoadingOptionsStep>,
    SearchLoadingOptionsStep {
        private final HibernateOrmLoadingSessionContext sessionContext;
        private final EntityLoaderBuilder<E> entityLoaderBuilder;
        private final MutableEntityLoadingOptions loadingOptions;

        public Builder(HibernateOrmLoadingMappingContext mappingContext, HibernateOrmLoadingSessionContext sessionContext, Set<HibernateOrmScopeIndexedTypeContext<? extends E>> indexedTypeContexts) {
            this.sessionContext = sessionContext;
            this.entityLoaderBuilder = new EntityLoaderBuilder(mappingContext, sessionContext, indexedTypeContexts);
            this.loadingOptions = new MutableEntityLoadingOptions(mappingContext);
        }

        public SearchLoadingOptionsStep toAPI() {
            return this;
        }

        @Override
        public SearchLoadingOptionsStep fetchSize(int fetchSize) {
            this.loadingOptions.fetchSize(fetchSize);
            return this;
        }

        @Override
        public SearchLoadingOptionsStep cacheLookupStrategy(EntityLoadingCacheLookupStrategy strategy) {
            this.entityLoaderBuilder.cacheLookupStrategy(strategy);
            return this;
        }

        @Override
        public SearchLoadingOptionsStep graph(EntityGraph<?> graph, GraphSemantic semantic) {
            this.loadingOptions.entityGraphHint(new EntityGraphHint((RootGraph)graph, semantic), false);
            return this;
        }

        @Override
        public SearchLoadingOptionsStep graph(String graphName, GraphSemantic semantic) {
            Contracts.assertNotNull((Object)graphName, (String)"graphName");
            return this.graph((EntityGraph<?>)this.sessionContext.session().getEntityGraph(graphName), semantic);
        }

        public LoadingContext<EntityReference, E> build() {
            DocumentReferenceConverter<EntityReference> referenceHitMapper = this.sessionContext.referenceHitMapper();
            EntityLoader<EntityReference, E> entityLoader = this.entityLoaderBuilder.build(this.loadingOptions);
            return new HibernateOrmLoadingContext(this.sessionContext.session(), referenceHitMapper, entityLoader, this.loadingOptions);
        }
    }
}

