/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.massindexing.impl;

import java.lang.invoke.MethodHandles;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import org.hibernate.StatelessSession;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.massindexing.impl.BatchTransactionalContext;
import org.hibernate.search.mapper.orm.massindexing.impl.FailureHandledRunnable;
import org.hibernate.search.mapper.orm.massindexing.impl.MassIndexingNotifier;
import org.hibernate.search.mapper.orm.massindexing.impl.StatelessSessionAwareRunnable;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class OptionallyWrapInJTATransaction
extends FailureHandledRunnable {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final BatchTransactionalContext batchContext;
    private final StatelessSessionAwareRunnable statelessSessionAwareRunnable;
    private final Integer transactionTimeout;
    private final boolean wrapInTransaction;
    private final String tenantId;

    public OptionallyWrapInJTATransaction(BatchTransactionalContext batchContext, MassIndexingNotifier notifier, StatelessSessionAwareRunnable statelessSessionAwareRunnable, Integer transactionTimeout, String tenantId) {
        super(notifier);
        this.batchContext = batchContext;
        this.transactionTimeout = transactionTimeout;
        this.tenantId = tenantId;
        this.statelessSessionAwareRunnable = statelessSessionAwareRunnable;
        this.wrapInTransaction = batchContext.wrapInTransaction();
    }

    @Override
    public void runWithFailureHandler() {
        block10: {
            if (this.wrapInTransaction) {
                try (StatelessSession statelessSession = this.batchContext.factory.withStatelessOptions().tenantIdentifier(this.tenantId).openStatelessSession();){
                    if (this.transactionTimeout != null) {
                        this.batchContext.transactionManager.setTransactionTimeout(this.transactionTimeout.intValue());
                    }
                    this.batchContext.transactionManager.begin();
                    this.statelessSessionAwareRunnable.run(statelessSession);
                    this.batchContext.transactionManager.commit();
                    break block10;
                }
                catch (HeuristicMixedException | HeuristicRollbackException | NotSupportedException | RollbackException | SystemException e) {
                    throw log.massIndexingTransactionHandlingException(e.getMessage(), e);
                }
            }
            this.statelessSessionAwareRunnable.run(null);
        }
    }

    @Override
    protected void cleanUpOnInterruption() {
        this.rollback();
    }

    @Override
    protected void cleanUpOnFailure() {
        this.rollback();
    }

    private void rollback() {
        if (this.wrapInTransaction) {
            try {
                this.batchContext.transactionManager.rollback();
            }
            catch (Exception e) {
                throw log.massIndexingTransactionHandlingException(e.getMessage(), e);
            }
        }
    }
}

