/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.massindexing.impl;

import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import javax.persistence.EntityManager;
import javax.persistence.LockModeType;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.metamodel.SingularAttribute;
import javax.transaction.TransactionManager;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.query.Query;
import org.hibernate.search.engine.backend.work.execution.DocumentCommitStrategy;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.massindexing.impl.HibernateOrmMassIndexingIndexedTypeContext;
import org.hibernate.search.mapper.orm.massindexing.impl.HibernateOrmMassIndexingMappingContext;
import org.hibernate.search.mapper.orm.massindexing.impl.HibernateOrmMassIndexingSessionContext;
import org.hibernate.search.mapper.orm.massindexing.impl.MassIndexingNotifier;
import org.hibernate.search.mapper.orm.massindexing.impl.ProducerConsumerQueue;
import org.hibernate.search.mapper.orm.scope.impl.HibernateOrmScopeSessionContext;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.work.spi.PojoIndexer;
import org.hibernate.search.util.common.impl.Futures;
import org.hibernate.search.util.common.impl.Throwables;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class IdentifierConsumerDocumentProducer<E, I>
implements Runnable {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final HibernateOrmMassIndexingMappingContext mappingContext;
    private final String tenantId;
    private final MassIndexingNotifier notifier;
    private final HibernateOrmMassIndexingIndexedTypeContext<E> type;
    private final SingularAttribute<? super E, I> idAttributeOfType;
    private final ProducerConsumerQueue<List<I>> source;
    private final CacheMode cacheMode;
    private final Integer transactionTimeout;
    private final TransactionManager transactionManager;

    IdentifierConsumerDocumentProducer(HibernateOrmMassIndexingMappingContext mappingContext, String tenantId, MassIndexingNotifier notifier, HibernateOrmMassIndexingIndexedTypeContext<E> type, SingularAttribute<? super E, I> idAttributeOfType, ProducerConsumerQueue<List<I>> fromIdentifierListToEntities, CacheMode cacheMode, Integer transactionTimeout) {
        this.mappingContext = mappingContext;
        this.tenantId = tenantId;
        this.notifier = notifier;
        this.source = fromIdentifierListToEntities;
        this.cacheMode = cacheMode;
        this.type = type;
        this.idAttributeOfType = idAttributeOfType;
        this.transactionTimeout = transactionTimeout;
        this.transactionManager = ((JtaPlatform)mappingContext.sessionFactory().getServiceRegistry().getService(JtaPlatform.class)).retrieveTransactionManager();
        log.trace("created");
    }

    @Override
    public void run() {
        log.trace("started");
        try (SessionImplementor session = (SessionImplementor)this.mappingContext.sessionFactory().withOptions().tenantIdentifier(this.tenantId).openSession();){
            session.setHibernateFlushMode(FlushMode.MANUAL);
            session.setCacheMode(this.cacheMode);
            session.setDefaultReadOnly(true);
            this.loadAndIndexAllFromQueue(session);
        }
        catch (RuntimeException exception) {
            this.notifier.notifyRunnableFailure(exception, log.massIndexingLoadingAndExtractingEntityData(this.type.jpaEntityName()));
        }
        log.trace("finished");
    }

    private void loadAndIndexAllFromQueue(SessionImplementor session) {
        HibernateOrmScopeSessionContext sessionContext = this.mappingContext.sessionContext((EntityManager)session);
        PojoIndexer indexer = sessionContext.createIndexer();
        try {
            List<I> idList;
            do {
                if ((idList = this.source.take()) == null) continue;
                log.tracef("received list of ids %s", idList);
                this.loadAndIndexList(idList, sessionContext, indexer);
            } while (idList != null);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void loadAndIndexList(List<I> listIds, HibernateOrmMassIndexingSessionContext sessionContext, PojoIndexer indexer) throws InterruptedException {
        SessionImplementor session = sessionContext.session();
        this.beginTransaction((Session)session);
        try {
            CriteriaBuilder criteriaBuilder = session.getCriteriaBuilder();
            CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(this.type.entityTypeDescriptor().getJavaType());
            Root root = criteriaQuery.from(this.type.entityTypeDescriptor());
            criteriaQuery.select((Selection)root);
            criteriaQuery.where((Expression)root.get(this.idAttributeOfType).in(listIds));
            Query query = session.createQuery(criteriaQuery).setCacheMode(this.cacheMode).setLockMode(LockModeType.NONE).setCacheable(false).setHibernateFlushMode(FlushMode.MANUAL).setFetchSize(listIds.size());
            this.indexList(sessionContext, indexer, query.getResultList());
            session.clear();
        }
        catch (Exception e) {
            try {
                this.rollbackTransaction(session);
            }
            catch (Exception e2) {
                e.addSuppressed(e2);
            }
            throw e;
        }
        this.commitTransaction(session);
    }

    private void beginTransaction(Session session) {
        try {
            if (this.transactionManager != null) {
                if (this.transactionTimeout != null) {
                    this.transactionManager.setTransactionTimeout(this.transactionTimeout.intValue());
                }
                this.transactionManager.begin();
            } else {
                session.beginTransaction();
            }
        }
        catch (Exception e) {
            throw log.massIndexingTransactionHandlingException(e.getMessage(), e);
        }
    }

    private void commitTransaction(SessionImplementor session) {
        try {
            if (this.transactionManager != null) {
                this.transactionManager.commit();
            } else {
                session.accessTransaction().commit();
            }
        }
        catch (Exception e) {
            throw log.massIndexingTransactionHandlingException(e.getMessage(), e);
        }
    }

    private void rollbackTransaction(SessionImplementor session) {
        try {
            if (this.transactionManager != null) {
                this.transactionManager.rollback();
            } else {
                session.accessTransaction().rollback();
            }
        }
        catch (Exception e) {
            throw log.massIndexingTransactionHandlingException(e.getMessage(), e);
        }
    }

    private void indexList(HibernateOrmMassIndexingSessionContext sessionContext, PojoIndexer indexer, List<E> entities) throws InterruptedException {
        if (entities == null || entities.isEmpty()) {
            return;
        }
        this.notifier.notifyEntitiesLoaded(entities.size());
        CompletableFuture[] indexingFutures = new CompletableFuture[entities.size()];
        for (int i = 0; i < entities.size(); ++i) {
            E entity = entities.get(i);
            indexingFutures[i] = this.index(sessionContext, indexer, entity);
        }
        Futures.unwrappedExceptionGet((Future)((Object)CompletableFuture.allOf(indexingFutures).exceptionally(exception -> null)));
        int successfulEntities = 0;
        for (int i = 0; i < entities.size(); ++i) {
            CompletableFuture future = indexingFutures[i];
            if (future.isCompletedExceptionally()) {
                E entity = entities.get(i);
                this.notifier.notifyEntityIndexingFailure(this.type, sessionContext, entity, Throwables.expectException((Throwable)Futures.getThrowableNow((CompletableFuture)future)));
                continue;
            }
            ++successfulEntities;
        }
        this.notifier.notifyDocumentsAdded(successfulEntities);
    }

    private CompletableFuture<?> index(HibernateOrmMassIndexingSessionContext sessionContext, PojoIndexer indexer, E entity) throws InterruptedException {
        CompletableFuture future;
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException();
        }
        try {
            PojoRawTypeIdentifier<E> typeIdentifier = this.detectTypeIdentifier(sessionContext, entity);
            future = indexer.add(typeIdentifier, null, null, entity, DocumentCommitStrategy.NONE, DocumentRefreshStrategy.NONE);
        }
        catch (RuntimeException e) {
            CompletableFuture future2 = new CompletableFuture();
            future2.completeExceptionally(e);
            return future2;
        }
        this.notifier.notifyDocumentBuilt();
        return future;
    }

    private PojoRawTypeIdentifier<? extends E> detectTypeIdentifier(HibernateOrmMassIndexingSessionContext sessionContext, E entity) {
        return sessionContext.runtimeIntrospector().detectEntityType(entity);
    }
}

