/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.orm.mapping.impl;

import java.lang.invoke.MethodHandles;
import java.util.function.Supplier;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.search.engine.common.spi.SearchIntegration;
import org.hibernate.search.mapper.orm.logging.impl.Log;
import org.hibernate.search.mapper.orm.mapping.impl.HibernateOrmMapping;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.service.Service;

public final class HibernateSearchContextProviderService
implements Service,
AutoCloseable,
Supplier<HibernateOrmMapping> {
    private volatile SearchIntegration integration;
    private volatile HibernateOrmMapping mapping;

    public static HibernateSearchContextProviderService get(SessionFactoryImplementor sessionFactory) {
        return (HibernateSearchContextProviderService)sessionFactory.getServiceRegistry().getService(HibernateSearchContextProviderService.class);
    }

    @Override
    public void close() {
        if (this.integration != null) {
            this.integration.close();
        }
    }

    public void initialize(SearchIntegration integration, HibernateOrmMapping mapping) {
        this.integration = integration;
        this.mapping = mapping;
    }

    @Override
    public HibernateOrmMapping get() {
        if (this.mapping != null) {
            return this.mapping;
        }
        throw ((Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup())).hibernateSearchNotInitialized();
    }

    SearchIntegration getIntegration() {
        return this.integration;
    }
}

