/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.sort.dsl.impl;

import java.util.function.Function;
import org.hibernate.search.engine.search.common.SortMode;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.dsl.PredicateFinalStep;
import org.hibernate.search.engine.search.predicate.dsl.TypedSearchPredicateFactory;
import org.hibernate.search.engine.search.sort.SearchSort;
import org.hibernate.search.engine.search.sort.dsl.DistanceSortMissingValueBehaviorStep;
import org.hibernate.search.engine.search.sort.dsl.DistanceSortOptionsStep;
import org.hibernate.search.engine.search.sort.dsl.SortOrder;
import org.hibernate.search.engine.search.sort.dsl.spi.AbstractSortThenStep;
import org.hibernate.search.engine.search.sort.dsl.spi.SearchSortDslContext;
import org.hibernate.search.engine.search.sort.spi.DistanceSortBuilder;
import org.hibernate.search.engine.search.sort.spi.SortTypeKeys;
import org.hibernate.search.engine.spatial.GeoPoint;

public class DistanceSortOptionsStepImpl<SR, PDF extends TypedSearchPredicateFactory<SR>>
extends AbstractSortThenStep<SR>
implements DistanceSortOptionsStep<SR, DistanceSortOptionsStepImpl<SR, PDF>, PDF>,
DistanceSortMissingValueBehaviorStep<DistanceSortOptionsStepImpl<SR, PDF>> {
    private final DistanceSortBuilder builder;
    private final SearchSortDslContext<SR, ?, ? extends PDF> dslContext;

    public DistanceSortOptionsStepImpl(SearchSortDslContext<SR, ?, ? extends PDF> dslContext, String fieldPath, GeoPoint center) {
        super(dslContext);
        this.dslContext = dslContext;
        this.builder = dslContext.scope().fieldQueryElement(fieldPath, SortTypeKeys.DISTANCE);
        this.builder.center(center);
    }

    @Override
    public DistanceSortOptionsStepImpl<SR, PDF> order(SortOrder order) {
        this.builder.order(order);
        return this;
    }

    @Override
    public DistanceSortOptionsStepImpl<SR, PDF> mode(SortMode mode) {
        this.builder.mode(mode);
        return this;
    }

    @Override
    public DistanceSortOptionsStepImpl<SR, PDF> filter(Function<? super PDF, ? extends PredicateFinalStep> clauseContributor) {
        SearchPredicate predicate = clauseContributor.apply(this.dslContext.predicateFactory()).toPredicate();
        return this.filter(predicate);
    }

    @Override
    public DistanceSortOptionsStepImpl<SR, PDF> filter(SearchPredicate searchPredicate) {
        this.builder.filter(searchPredicate);
        return this;
    }

    @Override
    public DistanceSortMissingValueBehaviorStep<DistanceSortOptionsStepImpl<SR, PDF>> missing() {
        return this;
    }

    @Override
    public DistanceSortOptionsStepImpl<SR, PDF> first() {
        this.builder.missingFirst();
        return this;
    }

    @Override
    public DistanceSortOptionsStepImpl<SR, PDF> last() {
        this.builder.missingLast();
        return this;
    }

    @Override
    public DistanceSortOptionsStepImpl<SR, PDF> highest() {
        this.builder.missingHighest();
        return this;
    }

    @Override
    public DistanceSortOptionsStepImpl<SR, PDF> lowest() {
        this.builder.missingLowest();
        return this;
    }

    @Override
    public DistanceSortOptionsStepImpl<SR, PDF> use(GeoPoint value) {
        this.builder.missingAs(value);
        return this;
    }

    @Override
    protected SearchSort build() {
        return this.builder.build();
    }
}

