/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.common.tree;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.hibernate.search.engine.logging.impl.MappingLog;

public final class TreeFilterDefinition {
    private static final TreeFilterDefinition INCLUDE_ALL = new TreeFilterDefinition(null, null, null);
    private final Set<String> includePaths;
    private final Set<String> excludePaths;
    private final Integer includeDepth;

    public static TreeFilterDefinition includeAll() {
        return INCLUDE_ALL;
    }

    public TreeFilterDefinition(Integer includeDepth, Set<String> includePaths, Set<String> excludePaths) {
        this.includePaths = includePaths == null ? Collections.emptySet() : new LinkedHashSet<String>(includePaths);
        LinkedHashSet<String> linkedHashSet = this.excludePaths = excludePaths == null ? Collections.emptySet() : new LinkedHashSet<String>(excludePaths);
        if (!this.includePaths.isEmpty() && !this.excludePaths.isEmpty()) {
            throw MappingLog.INSTANCE.cannotIncludeAndExcludePathsWithinSameFilter(includePaths, excludePaths);
        }
        this.includeDepth = includeDepth == null && !this.includePaths.isEmpty() ? Integer.valueOf(0) : includeDepth;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TreeFilterDefinition that = (TreeFilterDefinition)o;
        return Objects.equals(this.includeDepth, that.includeDepth) && this.includePaths.equals(that.includePaths) && this.excludePaths.equals(that.excludePaths);
    }

    public int hashCode() {
        return Objects.hash(this.includeDepth, this.includePaths, this.excludePaths);
    }

    public Set<String> includePaths() {
        return this.includePaths;
    }

    public Set<String> excludePaths() {
        return this.excludePaths;
    }

    public Integer includeDepth() {
        return this.includeDepth;
    }
}

