/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.sort.dsl.impl;

import org.hibernate.search.engine.search.predicate.dsl.SearchPredicateFactory;
import org.hibernate.search.engine.search.predicate.dsl.SearchPredicateFactoryExtension;
import org.hibernate.search.engine.search.sort.SearchSort;
import org.hibernate.search.engine.search.sort.dsl.spi.SearchSortDslContext;
import org.hibernate.search.engine.search.sort.spi.CompositeSortBuilder;
import org.hibernate.search.engine.search.sort.spi.SearchSortBuilderFactory;

public final class SearchSortDslContextImpl<F extends SearchSortBuilderFactory<?>, PDF extends SearchPredicateFactory>
implements SearchSortDslContext<F, PDF> {
    private final F factory;
    private final SearchSortDslContextImpl<F, ?> parent;
    private final SearchSort sort;
    private final PDF predicateFactory;
    private SearchSort compositeSort;

    public static <F extends SearchSortBuilderFactory<?>, PDF extends SearchPredicateFactory> SearchSortDslContext<F, ?> root(F factory, PDF predicateFactory) {
        return new SearchSortDslContextImpl<F, PDF>(factory, null, null, predicateFactory);
    }

    private SearchSortDslContextImpl(F factory, SearchSortDslContextImpl<F, ?> parent, SearchSort sort, PDF predicateFactory) {
        this.factory = factory;
        this.parent = parent;
        this.sort = sort;
        this.predicateFactory = predicateFactory;
    }

    @Override
    public F builderFactory() {
        return this.factory;
    }

    @Override
    public SearchSortDslContext<?, PDF> append(SearchSort sort) {
        return new SearchSortDslContextImpl<F, PDF>(this.factory, this, sort, this.predicateFactory);
    }

    @Override
    public PDF predicateFactory() {
        return this.predicateFactory;
    }

    @Override
    public <PDF2 extends SearchPredicateFactory> SearchSortDslContext<F, PDF2> withExtendedPredicateFactory(SearchPredicateFactoryExtension<PDF2> extension) {
        return new SearchSortDslContextImpl<F, SearchPredicateFactory>(this.factory, this.parent, this.sort, (SearchPredicateFactory)this.predicateFactory.extension(extension));
    }

    @Override
    public SearchSort toSort() {
        if (this.compositeSort == null) {
            this.compositeSort = this.createCompositeSort();
        }
        return this.compositeSort;
    }

    private SearchSort createCompositeSort() {
        if (this.parent == null) {
            return this.factory.composite().build();
        }
        if (this.parent.sort == null) {
            return this.sort;
        }
        CompositeSortBuilder builder = this.factory.composite();
        this.collectSorts(builder);
        return builder.build();
    }

    private void collectSorts(CompositeSortBuilder builder) {
        if (this.sort == null) {
            return;
        }
        super.collectSorts(builder);
        builder.add(this.sort);
    }
}

