/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.predicate.dsl.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.hibernate.search.engine.search.common.BooleanOperator;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.dsl.SimpleQueryFlag;
import org.hibernate.search.engine.search.predicate.dsl.SimpleQueryStringPredicateFieldMoreStep;
import org.hibernate.search.engine.search.predicate.dsl.SimpleQueryStringPredicateOptionsStep;
import org.hibernate.search.engine.search.predicate.dsl.spi.AbstractPredicateFinalStep;
import org.hibernate.search.engine.search.predicate.dsl.spi.SearchPredicateDslContext;
import org.hibernate.search.engine.search.predicate.spi.SimpleQueryStringPredicateBuilder;
import org.hibernate.search.util.common.impl.Contracts;

class SimpleQueryStringPredicateFieldMoreStepImpl
implements SimpleQueryStringPredicateFieldMoreStep<SimpleQueryStringPredicateFieldMoreStepImpl, SimpleQueryStringPredicateOptionsStep<?>> {
    private final CommonState commonState;
    private final List<SimpleQueryStringPredicateBuilder.FieldState> fieldStates = new ArrayList<SimpleQueryStringPredicateBuilder.FieldState>();

    SimpleQueryStringPredicateFieldMoreStepImpl(CommonState commonState, List<String> absoluteFieldPaths) {
        this.commonState = commonState;
        for (String absoluteFieldPath : absoluteFieldPaths) {
            this.fieldStates.add(commonState.field(absoluteFieldPath));
        }
    }

    @Override
    public SimpleQueryStringPredicateFieldMoreStepImpl fields(String ... absoluteFieldPaths) {
        return new SimpleQueryStringPredicateFieldMoreStepImpl(this.commonState, Arrays.asList(absoluteFieldPaths));
    }

    @Override
    public SimpleQueryStringPredicateFieldMoreStepImpl boost(float boost) {
        this.fieldStates.forEach(c -> c.boost(boost));
        return this;
    }

    @Override
    public SimpleQueryStringPredicateOptionsStep<?> matching(String simpleQueryString) {
        return this.commonState.matching(simpleQueryString);
    }

    static class CommonState
    extends AbstractPredicateFinalStep
    implements SimpleQueryStringPredicateOptionsStep<CommonState> {
        private final SimpleQueryStringPredicateBuilder builder;

        CommonState(SearchPredicateDslContext<?> dslContext) {
            super(dslContext);
            this.builder = dslContext.builderFactory().simpleQueryString();
        }

        @Override
        protected SearchPredicate build() {
            return this.builder.build();
        }

        SimpleQueryStringPredicateBuilder.FieldState field(String absoluteFieldPath) {
            return this.builder.field(absoluteFieldPath);
        }

        private SimpleQueryStringPredicateOptionsStep<?> matching(String simpleQueryString) {
            Contracts.assertNotNull((Object)simpleQueryString, (String)"simpleQueryString");
            this.builder.simpleQueryString(simpleQueryString);
            return this;
        }

        @Override
        public CommonState constantScore() {
            this.builder.constantScore();
            return this;
        }

        @Override
        public CommonState boost(float boost) {
            this.builder.boost(boost);
            return this;
        }

        @Override
        public CommonState defaultOperator(BooleanOperator operator) {
            this.builder.defaultOperator(operator);
            return this;
        }

        @Override
        public CommonState analyzer(String analyzerName) {
            this.builder.analyzer(analyzerName);
            return this;
        }

        @Override
        public CommonState skipAnalysis() {
            this.builder.skipAnalysis();
            return this;
        }

        @Override
        public CommonState flags(Set<SimpleQueryFlag> flags) {
            this.builder.flags(flags);
            return this;
        }
    }
}

