/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.cfg.impl;

import java.util.Optional;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertySource;
import org.hibernate.search.util.common.impl.Contracts;

public class MaskedConfigurationPropertySource
implements ConfigurationPropertySource {
    private final ConfigurationPropertySource propertiesToMask;
    private final String radix;

    public MaskedConfigurationPropertySource(ConfigurationPropertySource propertiesToMask, String mask) {
        Contracts.assertNotNull((Object)propertiesToMask, (String)"propertiesToMask");
        Contracts.assertNotNull((Object)mask, (String)"mask");
        this.propertiesToMask = propertiesToMask;
        this.radix = mask + ".";
    }

    @Override
    public Optional<?> get(String key) {
        return this.propertiesToMask.get(this.radix + key);
    }

    @Override
    public Optional<String> resolve(String key) {
        return this.propertiesToMask.resolve(this.radix + key);
    }

    @Override
    public ConfigurationPropertySource withMask(String mask) {
        return new MaskedConfigurationPropertySource(this.propertiesToMask, this.radix + mask);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[").append("mask=").append(this.radix).append(", propertiesToMask=").append(this.propertiesToMask).append("]");
        return sb.toString();
    }
}

