/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.cfg.impl;

import java.util.Optional;
import java.util.function.Consumer;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertySource;
import org.hibernate.search.util.common.impl.Contracts;

public class ListeningConfigurationPropertySource
implements ConfigurationPropertySource {
    private final ConfigurationPropertySource delegate;
    private final Consumer<String> listener;

    public ListeningConfigurationPropertySource(ConfigurationPropertySource delegate, Consumer<String> listener) {
        Contracts.assertNotNull((Object)delegate, (String)"delegate");
        Contracts.assertNotNull(listener, (String)"listener");
        this.delegate = delegate;
        this.listener = listener;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[delegate=" + this.delegate + ", listener=" + this.listener + "]";
    }

    @Override
    public Optional<?> get(String key) {
        Optional<?> result = this.delegate.get(key);
        if (result.isPresent()) {
            this.listener.accept(this.delegate.resolve(key).orElse("<Could not resolve: " + key + ">"));
        }
        return result;
    }

    @Override
    public Optional<String> resolve(String key) {
        return this.delegate.resolve(key);
    }
}

