/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.aggregation.impl;

import java.util.Set;
import org.hibernate.search.backend.lucene.logging.impl.QueryLog;
import org.hibernate.search.backend.lucene.lowlevel.aggregation.collector.impl.CountDocuemntsCollectorFactory;
import org.hibernate.search.backend.lucene.lowlevel.aggregation.collector.impl.CountDocumentsCollector;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorKey;
import org.hibernate.search.backend.lucene.search.aggregation.impl.AggregationExtractContext;
import org.hibernate.search.backend.lucene.search.aggregation.impl.AggregationRequestContext;
import org.hibernate.search.backend.lucene.search.aggregation.impl.LuceneSearchAggregation;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexNodeContext;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.engine.search.aggregation.spi.CountDocumentAggregationBuilder;
import org.hibernate.search.engine.search.common.spi.SearchQueryElementFactory;

public class LuceneCountDocumentAggregation
implements LuceneSearchAggregation<Long> {
    private final Set<String> indexNames;

    private LuceneCountDocumentAggregation(Builder builder) {
        this.indexNames = builder.scope.hibernateSearchIndexNames();
    }

    public static Factory factory() {
        return Factory.INSTANCE;
    }

    @Override
    public LuceneSearchAggregation.Extractor<Long> request(AggregationRequestContext context) {
        CountDocuemntsCollectorFactory collectorFactory = CountDocuemntsCollectorFactory.instance();
        CollectorKey<CountDocumentsCollector, Long> collectorKey = collectorFactory.getCollectorKey();
        context.requireCollector(collectorFactory);
        return new CountDocumentsExtractor(collectorKey);
    }

    @Override
    public Set<String> indexNames() {
        return this.indexNames;
    }

    private record Builder(LuceneSearchIndexScope<?> scope) implements CountDocumentAggregationBuilder
    {
        public LuceneCountDocumentAggregation build() {
            return new LuceneCountDocumentAggregation(this);
        }
    }

    protected static class Factory
    implements SearchQueryElementFactory<CountDocumentAggregationBuilder.TypeSelector, LuceneSearchIndexScope<?>, LuceneSearchIndexNodeContext> {
        private static final Factory INSTANCE = new Factory();

        private Factory() {
        }

        public CountDocumentAggregationBuilder.TypeSelector create(LuceneSearchIndexScope<?> scope, LuceneSearchIndexNodeContext node) {
            return new TypeSelector(scope, node);
        }

        public void checkCompatibleWith(SearchQueryElementFactory<?, ?, ?> other) {
            if (!this.getClass().equals(other.getClass())) {
                throw QueryLog.INSTANCE.differentImplementationClassForQueryElement(this.getClass(), other.getClass());
            }
        }
    }

    private record CountDocumentsExtractor(CollectorKey<?, Long> collectorKey) implements LuceneSearchAggregation.Extractor<Long>
    {
        @Override
        public Long extract(AggregationExtractContext context) {
            return context.getCollectorResults(this.collectorKey);
        }
    }

    private record TypeSelector(LuceneSearchIndexScope<?> scope, LuceneSearchIndexNodeContext node) implements CountDocumentAggregationBuilder.TypeSelector
    {
        public CountDocumentAggregationBuilder builder() {
            return new Builder(this.scope);
        }
    }
}

