/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.codec.impl;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.codecs.KnnVectorsFormat;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.KnnVectorsWriter;
import org.apache.lucene.codecs.lucene99.Lucene99HnswVectorsFormat;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SegmentWriteState;

public class HibernateSearchKnnVectorsFormat
extends KnnVectorsFormat {
    public static final int DEFAULT_MAX_DIMENSIONS = 16000;
    private static final KnnVectorsFormat DEFAULT_KNN_VECTORS_FORMAT = new HibernateSearchKnnVectorsFormat();
    private final KnnVectorsFormat delegate;
    private final int m;
    private final int efConstruction;

    public static KnnVectorsFormat defaultFormat() {
        return DEFAULT_KNN_VECTORS_FORMAT;
    }

    public HibernateSearchKnnVectorsFormat() {
        this(16, 100);
    }

    public HibernateSearchKnnVectorsFormat(int m, int efConstruction) {
        this((KnnVectorsFormat)new Lucene99HnswVectorsFormat(m, efConstruction), m, efConstruction);
    }

    public HibernateSearchKnnVectorsFormat(KnnVectorsFormat delegate, int m, int efConstruction) {
        super(delegate.getName());
        this.delegate = delegate;
        this.m = m;
        this.efConstruction = efConstruction;
    }

    public KnnVectorsWriter fieldsWriter(SegmentWriteState state) throws IOException {
        return this.delegate.fieldsWriter(state);
    }

    public KnnVectorsReader fieldsReader(SegmentReadState state) throws IOException {
        return this.delegate.fieldsReader(state);
    }

    public int getMaxDimensions(String fieldName) {
        return 16000;
    }

    public KnnVectorsFormat delegate() {
        return this.delegate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        HibernateSearchKnnVectorsFormat that = (HibernateSearchKnnVectorsFormat)((Object)o);
        return this.m == that.m && this.efConstruction == that.efConstruction;
    }

    public int hashCode() {
        return Objects.hash(this.m, this.efConstruction);
    }

    public String toString() {
        return "HibernateSearchKnnVectorsFormat{m=" + this.m + ", efConstruction=" + this.efConstruction + "}";
    }
}

