/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.search.engine.EntityInfo;
import org.hibernate.search.engine.Loader;
import org.hibernate.search.engine.ObjectLoader;
import org.hibernate.search.engine.SearchFactoryImplementor;

public class ProjectionLoader
implements Loader {
    private SearchFactoryImplementor searchFactoryImplementor;
    private Session session;
    private ObjectLoader objectLoader;
    private Boolean projectThis;

    public void init(Session session, SearchFactoryImplementor searchFactoryImplementor) {
        this.session = session;
        this.searchFactoryImplementor = searchFactoryImplementor;
    }

    public Object load(EntityInfo entityInfo) {
        this.initThisProjectionFlag(entityInfo);
        if (this.projectThis.booleanValue()) {
            for (int index : entityInfo.indexesOfThis) {
                entityInfo.projection[index] = this.objectLoader.load(entityInfo);
            }
        }
        return entityInfo.projection;
    }

    private void initThisProjectionFlag(EntityInfo entityInfo) {
        if (this.projectThis == null) {
            this.projectThis = entityInfo.indexesOfThis != null;
            if (this.projectThis.booleanValue()) {
                this.objectLoader = new ObjectLoader();
                this.objectLoader.init(this.session, this.searchFactoryImplementor);
            }
        }
    }

    public List load(EntityInfo ... entityInfos) {
        ArrayList<Object[]> results = new ArrayList<Object[]>(entityInfos.length);
        if (entityInfos.length == 0) {
            return results;
        }
        this.initThisProjectionFlag(entityInfos[0]);
        if (this.projectThis.booleanValue()) {
            this.objectLoader.load(entityInfos);
            for (EntityInfo entityInfo : entityInfos) {
                for (int index : entityInfo.indexesOfThis) {
                    entityInfo.projection[index] = this.objectLoader.load(entityInfo);
                }
            }
        }
        for (EntityInfo entityInfo : entityInfos) {
            results.add(entityInfo.projection);
        }
        return results;
    }
}

