/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.SimpleAnalyzer;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.LuceneIndexingParameters;
import org.hibernate.search.engine.DocumentBuilder;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.optimization.OptimizerStrategy;

public class Workspace {
    private static Log log = LogFactory.getLog(Workspace.class);
    private Map<DirectoryProvider, IndexReader> readers = new HashMap<DirectoryProvider, IndexReader>();
    private Map<DirectoryProvider, IndexWriter> writers = new HashMap<DirectoryProvider, IndexWriter>();
    private List<DirectoryProvider> lockedProviders = new ArrayList<DirectoryProvider>();
    private Map<DirectoryProvider, DPStatistics> dpStatistics = new HashMap<DirectoryProvider, DPStatistics>();
    private SearchFactoryImplementor searchFactoryImplementor;
    private boolean isBatch = false;

    public Workspace(SearchFactoryImplementor searchFactoryImplementor) {
        this.searchFactoryImplementor = searchFactoryImplementor;
    }

    public DocumentBuilder getDocumentBuilder(Class entity) {
        return this.searchFactoryImplementor.getDocumentBuilders().get(entity);
    }

    public IndexReader getIndexReader(DirectoryProvider provider, Class entity) {
        if (this.writers.containsKey(provider)) {
            throw new AssertionFailure("Tries to read for update an index while a writer is accessed" + entity);
        }
        IndexReader reader = this.readers.get(provider);
        if (reader != null) {
            return reader;
        }
        this.lockProvider(provider);
        ++this.dpStatistics.get((Object)provider).operations;
        try {
            reader = IndexReader.open(provider.getDirectory());
            this.readers.put(provider, reader);
        }
        catch (IOException e) {
            this.cleanUp(new SearchException("Unable to open IndexReader for " + entity, e));
        }
        return reader;
    }

    public IndexWriter getIndexWriter(DirectoryProvider provider) {
        return this.getIndexWriter(provider, null, false);
    }

    public IndexWriter getIndexWriter(DirectoryProvider provider, Class entity, boolean modificationOperation) {
        IndexWriter writer;
        IndexReader reader = this.readers.get(provider);
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException e) {
                throw new SearchException("Exception while closing IndexReader", e);
            }
            this.readers.remove(provider);
        }
        if ((writer = this.writers.get(provider)) != null) {
            return writer;
        }
        this.lockProvider(provider);
        if (modificationOperation) {
            ++this.dpStatistics.get((Object)provider).operations;
        }
        try {
            SimpleAnalyzer analyzer = entity != null ? this.searchFactoryImplementor.getDocumentBuilders().get(entity).getAnalyzer() : new SimpleAnalyzer();
            writer = new IndexWriter(provider.getDirectory(), (Analyzer)analyzer, false);
            LuceneIndexingParameters indexingParams = this.searchFactoryImplementor.getIndexingParameters(provider);
            if (this.isBatch) {
                writer.setMergeFactor(indexingParams.getBatchMergeFactor());
                writer.setMaxMergeDocs(indexingParams.getBatchMaxMergeDocs());
                writer.setMaxBufferedDocs(indexingParams.getBatchMaxBufferedDocs());
            } else {
                writer.setMergeFactor(indexingParams.getTransactionMergeFactor());
                writer.setMaxMergeDocs(indexingParams.getTransactionMaxMergeDocs());
                writer.setMaxBufferedDocs(indexingParams.getTransactionMaxBufferedDocs());
            }
            this.writers.put(provider, writer);
        }
        catch (IOException e) {
            this.cleanUp(new SearchException("Unable to open IndexWriter" + (entity != null ? " for " + entity : ""), e));
        }
        return writer;
    }

    private void lockProvider(DirectoryProvider provider) {
        ReentrantLock lock = this.searchFactoryImplementor.getLockableDirectoryProviders().get(provider);
        if (!lock.isHeldByCurrentThread()) {
            lock.lock();
            this.lockedProviders.add(provider);
            this.dpStatistics.put(provider, new DPStatistics());
        }
    }

    private void cleanUp(SearchException originalException) {
        SearchException raisedException = originalException;
        for (IndexReader reader : this.readers.values()) {
            try {
                reader.close();
            }
            catch (IOException e) {
                if (raisedException != null) {
                    log.error((Object)"Subsequent Exception while closing IndexReader", (Throwable)e);
                    continue;
                }
                raisedException = new SearchException("Exception while closing IndexReader", e);
            }
        }
        this.readers.clear();
        if (raisedException == null) {
            for (DirectoryProvider provider : this.lockedProviders) {
                DPStatistics stats = this.dpStatistics.get(provider);
                if (stats.optimizationForced) continue;
                OptimizerStrategy optimizerStrategy = this.searchFactoryImplementor.getOptimizerStrategy(provider);
                optimizerStrategy.addTransaction(stats.operations);
                try {
                    optimizerStrategy.optimize(this);
                }
                catch (SearchException e) {
                    raisedException = new SearchException("Exception while optimizing directoryProvider: " + provider.getDirectory().toString(), e);
                    break;
                }
            }
        }
        for (IndexWriter writer : this.writers.values()) {
            try {
                writer.close();
            }
            catch (IOException e) {
                if (raisedException != null) {
                    log.error((Object)"Subsequent Exception while closing IndexWriter", (Throwable)e);
                    continue;
                }
                raisedException = new SearchException("Exception while closing IndexWriter", e);
            }
        }
        for (DirectoryProvider provider : this.lockedProviders) {
            this.searchFactoryImplementor.getLockableDirectoryProviders().get(provider).unlock();
        }
        this.writers.clear();
        this.lockedProviders.clear();
        this.dpStatistics.clear();
        if (raisedException != null) {
            throw raisedException;
        }
    }

    public void clean() {
        this.cleanUp(null);
    }

    public void optimize(DirectoryProvider provider) {
        OptimizerStrategy optimizerStrategy = this.searchFactoryImplementor.getOptimizerStrategy(provider);
        this.dpStatistics.get((Object)provider).optimizationForced = true;
        optimizerStrategy.optimizationForced();
    }

    public boolean isBatch() {
        return this.isBatch;
    }

    public void setBatch(boolean isBatch) {
        this.isBatch = isBatch;
    }

    private class DPStatistics {
        boolean optimizationForced = false;
        public long operations;

        private DPStatistics() {
        }
    }
}

