/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.hibernate.impl;

import java.util.List;
import org.hibernate.Session;
import org.hibernate.search.engine.spi.SearchFactoryImplementor;
import org.hibernate.search.query.engine.spi.EntityInfo;
import org.hibernate.search.query.hibernate.impl.Loader;
import org.hibernate.search.stat.spi.StatisticsImplementor;

public abstract class AbstractLoader
implements Loader {
    private StatisticsImplementor statisticsImplementor;
    private boolean takeTimings;

    public void init(Session session, SearchFactoryImplementor searchFactoryImplementor) {
        this.statisticsImplementor = searchFactoryImplementor.getStatisticsImplementor();
        this.takeTimings = searchFactoryImplementor.getStatistics().isStatisticsEnabled();
    }

    @Override
    public final Object load(EntityInfo entityInfo) {
        long startTime = 0L;
        if (this.takeTimings) {
            startTime = System.nanoTime();
        }
        Object loadedObject = this.executeLoad(entityInfo);
        if (this.takeTimings) {
            this.statisticsImplementor.objectLoadExecuted(1L, System.nanoTime() - startTime);
        }
        return loadedObject;
    }

    @Override
    public Object loadWithoutTiming(EntityInfo entityInfo) {
        return this.executeLoad(entityInfo);
    }

    public abstract Object executeLoad(EntityInfo var1);

    @Override
    public List load(EntityInfo ... entityInfos) {
        long startTime = 0L;
        if (this.takeTimings) {
            startTime = System.nanoTime();
        }
        List loadedObjects = this.executeLoad(entityInfos);
        if (this.takeTimings) {
            this.statisticsImplementor.objectLoadExecuted((long)loadedObjects.size(), System.nanoTime() - startTime);
        }
        return loadedObjects;
    }

    public abstract List executeLoad(EntityInfo ... var1);
}

