/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.util.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class FileHelper {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private static final int FAT_PRECISION = 2000;

    private FileHelper() {
    }

    public static boolean areInSync(Path source, Path destination) throws IOException {
        if (Files.isDirectory(source, new LinkOption[0])) {
            Set destinationFilenameSet;
            if (!Files.exists(destination, new LinkOption[0])) {
                return false;
            }
            if (!Files.isDirectory(destination, new LinkOption[0])) {
                throw new IOException("Source and Destination not of the same type:" + source.toAbsolutePath().toString() + " , " + destination.toAbsolutePath().toString());
            }
            Set<Path> sources = FileHelper.listFiles(source);
            Set sourcesFilenameSet = sources.stream().map(v -> v.getFileName().toString()).collect(Collectors.toSet());
            Stream<Path> dests = Files.list(destination);
            Object object = null;
            try {
                destinationFilenameSet = dests.map(v -> v.getFileName().toString()).collect(Collectors.toSet());
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (dests != null) {
                    if (object != null) {
                        try {
                            dests.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        dests.close();
                    }
                }
            }
            if (!sourcesFilenameSet.equals(destinationFilenameSet)) {
                return false;
            }
            boolean inSync = true;
            for (Path src : sources) {
                Path destFile;
                if (FileHelper.areInSync(src, destFile = destination.resolve(src.getFileName()))) continue;
                inSync = false;
                break;
            }
            return inSync;
        }
        if (Files.exists(destination, new LinkOption[0]) && Files.isRegularFile(destination, new LinkOption[0])) {
            long dts;
            long sts = Files.getLastModifiedTime(source, new LinkOption[0]).toMillis() / 2000L;
            return sts == (dts = Files.getLastModifiedTime(destination, new LinkOption[0]).toMillis() / 2000L);
        }
        return false;
    }

    public static void synchronize(Path source, Path destination, boolean smart) throws IOException {
        if (Files.isDirectory(source, new LinkOption[0])) {
            Files.createDirectories(destination, new FileAttribute[0]);
            Set<Path> sources = FileHelper.listFiles(source);
            Set sourceFilenames = sources.stream().map(v -> v.getFileName().toString()).collect(Collectors.toSet());
            Set<Path> dests = FileHelper.listFiles(destination);
            Set destFilenames = dests.stream().map(v -> v.getFileName().toString()).collect(Collectors.toSet());
            for (String fileName : destFilenames) {
                if (sourceFilenames.contains(fileName)) continue;
                FileHelper.delete(destination.resolve(fileName));
            }
            for (Path srcFile : sources) {
                Path destFile = destination.resolve(srcFile.getFileName());
                FileHelper.synchronize(srcFile, destFile, smart);
            }
        } else {
            if (Files.exists(destination, new LinkOption[0]) && Files.isDirectory(destination, new LinkOption[0])) {
                FileHelper.tryDelete(destination);
            }
            if (Files.exists(destination, new LinkOption[0])) {
                long sts = Files.getLastModifiedTime(source, new LinkOption[0]).toMillis() / 2000L;
                long dts = Files.getLastModifiedTime(destination, new LinkOption[0]).toMillis() / 2000L;
                if (!smart || sts == 0L || sts != dts || source.toFile().length() != destination.toFile().length()) {
                    FileHelper.copyFile(source, destination);
                }
            } else {
                FileHelper.copyFile(source, destination);
            }
        }
    }

    private static Set<Path> listFiles(Path directory) throws IOException {
        try (Stream<Path> stream = Files.list(directory);){
            Set<Path> set = stream.collect(Collectors.toSet());
            return set;
        }
    }

    private static void copyFile(Path source, Path destination) throws IOException {
        Files.copy(source, destination, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
    }

    public static void delete(Path path) throws IOException {
        FileHelper.deleteRecursive(path, false);
    }

    public static void tryDelete(Path path) throws IOException {
        FileHelper.deleteRecursive(path, true);
    }

    private static void deleteRecursive(Path path, final boolean ignoreExceptions) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException();
        }
        if (Files.notExists(path, new LinkOption[0])) {
            return;
        }
        Files.walkFileTree(path, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                FileHelper.delete(file, ignoreExceptions);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                FileHelper.delete(dir, ignoreExceptions);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private static void delete(Path file, boolean ignoreExceptions) throws IOException {
        if (ignoreExceptions) {
            FileHelper.safeDelete(file);
        } else {
            FileHelper.deleteOrFail(file);
        }
    }

    private static void safeDelete(Path file) {
        try {
            Files.deleteIfExists(file);
        }
        catch (IOException e) {
            log.fileDeleteFailureIgnored(e);
        }
    }

    private static void deleteOrFail(Path file) throws IOException {
        Files.delete(file);
    }
}

