/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.indexes.serialization.spi;

import org.apache.lucene.document.NumericField;
import org.apache.lucene.index.FieldInfo;
import org.hibernate.search.indexes.serialization.spi.SerializableStore;

public class LuceneNumericFieldContext {
    private NumericField field;

    public LuceneNumericFieldContext(NumericField numericField) {
        this.field = numericField;
    }

    public String getName() {
        return this.field.name();
    }

    public int getPrecisionStep() {
        return this.field.getPrecisionStep();
    }

    public SerializableStore getStore() {
        return this.field.isStored() ? SerializableStore.YES : SerializableStore.NO;
    }

    public boolean isIndexed() {
        return this.field.isIndexed();
    }

    public float getBoost() {
        return this.field.getBoost();
    }

    public boolean getOmitNorms() {
        return this.field.getOmitNorms();
    }

    public boolean getOmitTermFreqAndPositions() {
        return this.field.getIndexOptions() == FieldInfo.IndexOptions.DOCS_ONLY;
    }
}

