/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.event;

import java.util.Iterator;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.cfg.Configuration;
import org.hibernate.ejb.event.CallbackHandlerConsumer;
import org.hibernate.ejb.event.EJB3AutoFlushEventListener;
import org.hibernate.ejb.event.EJB3DeleteEventListener;
import org.hibernate.ejb.event.EJB3FlushEntityEventListener;
import org.hibernate.ejb.event.EJB3FlushEventListener;
import org.hibernate.ejb.event.EJB3MergeEventListener;
import org.hibernate.ejb.event.EJB3PersistEventListener;
import org.hibernate.ejb.event.EJB3PersistOnFlushEventListener;
import org.hibernate.ejb.event.EJB3PostDeleteEventListener;
import org.hibernate.ejb.event.EJB3PostInsertEventListener;
import org.hibernate.ejb.event.EJB3PostLoadEventListener;
import org.hibernate.ejb.event.EJB3PostUpdateEventListener;
import org.hibernate.ejb.event.EJB3SaveEventListener;
import org.hibernate.ejb.event.EJB3SaveOrUpdateEventListener;
import org.hibernate.ejb.event.EntityCallbackHandler;
import org.hibernate.ejb.event.HibernateEntityManagerEventListener;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.event.service.spi.DuplicationStrategy;
import org.hibernate.event.service.spi.EventListenerGroup;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.AutoFlushEventListener;
import org.hibernate.event.spi.DeleteEventListener;
import org.hibernate.event.spi.EventType;
import org.hibernate.event.spi.FlushEntityEventListener;
import org.hibernate.event.spi.FlushEventListener;
import org.hibernate.event.spi.MergeEventListener;
import org.hibernate.event.spi.PersistEventListener;
import org.hibernate.event.spi.PostDeleteEventListener;
import org.hibernate.event.spi.PostInsertEventListener;
import org.hibernate.event.spi.PostLoadEventListener;
import org.hibernate.event.spi.PostUpdateEventListener;
import org.hibernate.event.spi.PreDeleteEventListener;
import org.hibernate.event.spi.PreInsertEventListener;
import org.hibernate.event.spi.PreLoadEventListener;
import org.hibernate.event.spi.PreUpdateEventListener;
import org.hibernate.event.spi.SaveOrUpdateEventListener;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.secure.internal.JACCPreDeleteEventListener;
import org.hibernate.secure.internal.JACCPreInsertEventListener;
import org.hibernate.secure.internal.JACCPreLoadEventListener;
import org.hibernate.secure.internal.JACCPreUpdateEventListener;
import org.hibernate.secure.internal.JACCSecurityListener;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.service.spi.SessionFactoryServiceRegistry;

public class JpaIntegrator
implements Integrator {
    private static final DuplicationStrategy JPA_DUPLICATION_STRATEGY = new DuplicationStrategy(){

        public boolean areMatch(Object listener, Object original) {
            return listener.getClass().equals(original.getClass()) && HibernateEntityManagerEventListener.class.isInstance(original);
        }

        public DuplicationStrategy.Action getAction() {
            return DuplicationStrategy.Action.KEEP_ORIGINAL;
        }
    };
    private static final DuplicationStrategy JACC_DUPLICATION_STRATEGY = new DuplicationStrategy(){

        public boolean areMatch(Object listener, Object original) {
            return listener.getClass().equals(original.getClass()) && JACCSecurityListener.class.isInstance(original);
        }

        public DuplicationStrategy.Action getAction() {
            return DuplicationStrategy.Action.KEEP_ORIGINAL;
        }
    };

    public void integrate(Configuration configuration, SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
        EventListenerGroup eventListenerGroup;
        EventListenerRegistry eventListenerRegistry = (EventListenerRegistry)serviceRegistry.getService(EventListenerRegistry.class);
        boolean isSecurityEnabled = configuration.getProperties().containsKey("hibernate.jacc.enabled");
        eventListenerRegistry.addDuplicationStrategy(JPA_DUPLICATION_STRATEGY);
        eventListenerRegistry.addDuplicationStrategy(JACC_DUPLICATION_STRATEGY);
        eventListenerRegistry.setListeners(EventType.AUTO_FLUSH, (Object[])new AutoFlushEventListener[]{EJB3AutoFlushEventListener.INSTANCE});
        eventListenerRegistry.setListeners(EventType.DELETE, (Object[])new DeleteEventListener[]{new EJB3DeleteEventListener()});
        eventListenerRegistry.setListeners(EventType.FLUSH_ENTITY, (Object[])new FlushEntityEventListener[]{new EJB3FlushEntityEventListener()});
        eventListenerRegistry.setListeners(EventType.FLUSH, (Object[])new FlushEventListener[]{EJB3FlushEventListener.INSTANCE});
        eventListenerRegistry.setListeners(EventType.MERGE, (Object[])new MergeEventListener[]{new EJB3MergeEventListener()});
        eventListenerRegistry.setListeners(EventType.PERSIST, (Object[])new PersistEventListener[]{new EJB3PersistEventListener()});
        eventListenerRegistry.setListeners(EventType.PERSIST_ONFLUSH, (Object[])new PersistEventListener[]{new EJB3PersistOnFlushEventListener()});
        eventListenerRegistry.setListeners(EventType.SAVE, (Object[])new SaveOrUpdateEventListener[]{new EJB3SaveEventListener()});
        eventListenerRegistry.setListeners(EventType.SAVE_UPDATE, (Object[])new SaveOrUpdateEventListener[]{new EJB3SaveOrUpdateEventListener()});
        if (isSecurityEnabled) {
            String jaccContextId = configuration.getProperty("hibernate.jacc_context_id");
            eventListenerRegistry.prependListeners(EventType.PRE_DELETE, (Object[])new PreDeleteEventListener[]{new JACCPreDeleteEventListener(jaccContextId)});
            eventListenerRegistry.prependListeners(EventType.PRE_INSERT, (Object[])new PreInsertEventListener[]{new JACCPreInsertEventListener(jaccContextId)});
            eventListenerRegistry.prependListeners(EventType.PRE_UPDATE, (Object[])new PreUpdateEventListener[]{new JACCPreUpdateEventListener(jaccContextId)});
            eventListenerRegistry.prependListeners(EventType.PRE_LOAD, (Object[])new PreLoadEventListener[]{new JACCPreLoadEventListener(jaccContextId)});
        }
        eventListenerRegistry.prependListeners(EventType.POST_DELETE, (Object[])new PostDeleteEventListener[]{new EJB3PostDeleteEventListener()});
        eventListenerRegistry.prependListeners(EventType.POST_INSERT, (Object[])new PostInsertEventListener[]{new EJB3PostInsertEventListener()});
        eventListenerRegistry.prependListeners(EventType.POST_LOAD, (Object[])new PostLoadEventListener[]{new EJB3PostLoadEventListener()});
        eventListenerRegistry.prependListeners(EventType.POST_UPDATE, (Object[])new PostUpdateEventListener[]{new EJB3PostUpdateEventListener()});
        for (Map.Entry<Object, Object> entry : configuration.getProperties().entrySet()) {
            String propertyName;
            if (!String.class.isInstance(entry.getKey()) || !(propertyName = (String)entry.getKey()).startsWith("hibernate.ejb.event")) continue;
            String eventTypeName = propertyName.substring("hibernate.ejb.event".length() + 1);
            EventType eventType = EventType.resolveEventTypeByName((String)eventTypeName);
            eventListenerGroup = eventListenerRegistry.getEventListenerGroup(eventType);
            for (String listenerImpl : ((String)entry.getValue()).split(" ,")) {
                eventListenerGroup.appendListener(this.instantiate(listenerImpl, (ServiceRegistryImplementor)serviceRegistry));
            }
        }
        EntityCallbackHandler callbackHandler = new EntityCallbackHandler();
        Iterator classes = configuration.getClassMappings();
        ReflectionManager reflectionManager = configuration.getReflectionManager();
        while (classes.hasNext()) {
            PersistentClass clazz = (PersistentClass)classes.next();
            if (clazz.getClassName() == null) continue;
            try {
                callbackHandler.add(reflectionManager.classForName(clazz.getClassName(), this.getClass()), reflectionManager);
            }
            catch (ClassNotFoundException e) {
                throw new MappingException("entity class not found: " + clazz.getNodeName(), (Throwable)e);
            }
        }
        for (EventType eventType : EventType.values()) {
            eventListenerGroup = eventListenerRegistry.getEventListenerGroup(eventType);
            for (Object listener : eventListenerGroup.listeners()) {
                if (!CallbackHandlerConsumer.class.isInstance(listener)) continue;
                ((CallbackHandlerConsumer)listener).setCallbackHandler(callbackHandler);
            }
        }
    }

    public void disintegrate(SessionFactoryImplementor sessionFactory, SessionFactoryServiceRegistry serviceRegistry) {
    }

    private Object instantiate(String listenerImpl, ServiceRegistryImplementor serviceRegistry) {
        try {
            return ((ClassLoaderService)serviceRegistry.getService(ClassLoaderService.class)).classForName(listenerImpl).newInstance();
        }
        catch (Exception e) {
            throw new HibernateException("Could not instantiate requested listener [" + listenerImpl + "]", (Throwable)e);
        }
    }
}

