/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.ehcache;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.util.Timestamper;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.ehcache.EhCacheMessageLogger;
import org.hibernate.cache.ehcache.internal.nonstop.NonstopAccessStrategyFactory;
import org.hibernate.cache.ehcache.internal.regions.EhcacheCollectionRegion;
import org.hibernate.cache.ehcache.internal.regions.EhcacheEntityRegion;
import org.hibernate.cache.ehcache.internal.regions.EhcacheNaturalIdRegion;
import org.hibernate.cache.ehcache.internal.regions.EhcacheQueryResultsRegion;
import org.hibernate.cache.ehcache.internal.regions.EhcacheTimestampsRegion;
import org.hibernate.cache.ehcache.internal.strategy.EhcacheAccessStrategyFactory;
import org.hibernate.cache.ehcache.internal.strategy.EhcacheAccessStrategyFactoryImpl;
import org.hibernate.cache.ehcache.internal.util.HibernateEhcacheUtils;
import org.hibernate.cache.ehcache.management.impl.ProviderMBeanRegistrationHelper;
import org.hibernate.cache.spi.CacheDataDescription;
import org.hibernate.cache.spi.CollectionRegion;
import org.hibernate.cache.spi.EntityRegion;
import org.hibernate.cache.spi.NaturalIdRegion;
import org.hibernate.cache.spi.QueryResultsRegion;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.TimestampsRegion;
import org.hibernate.cache.spi.access.AccessType;
import org.hibernate.cfg.Settings;
import org.hibernate.service.spi.InjectService;
import org.jboss.logging.Logger;

abstract class AbstractEhcacheRegionFactory
implements RegionFactory {
    public static final String NET_SF_EHCACHE_CONFIGURATION_RESOURCE_NAME = "net.sf.ehcache.configurationResourceName";
    private static final EhCacheMessageLogger LOG = (EhCacheMessageLogger)Logger.getMessageLogger(EhCacheMessageLogger.class, (String)AbstractEhcacheRegionFactory.class.getName());
    protected final ProviderMBeanRegistrationHelper mbeanRegistrationHelper = new ProviderMBeanRegistrationHelper();
    protected volatile CacheManager manager;
    protected Settings settings;
    protected final EhcacheAccessStrategyFactory accessStrategyFactory = new NonstopAccessStrategyFactory(new EhcacheAccessStrategyFactoryImpl());
    private ClassLoaderService classLoaderService;

    AbstractEhcacheRegionFactory() {
    }

    public boolean isMinimalPutsEnabledByDefault() {
        return true;
    }

    public long nextTimestamp() {
        return Timestamper.next();
    }

    public EntityRegion buildEntityRegion(String regionName, Properties properties, CacheDataDescription metadata) throws CacheException {
        return new EhcacheEntityRegion(this.accessStrategyFactory, this.getCache(regionName), this.settings, metadata, properties);
    }

    public NaturalIdRegion buildNaturalIdRegion(String regionName, Properties properties, CacheDataDescription metadata) throws CacheException {
        return new EhcacheNaturalIdRegion(this.accessStrategyFactory, this.getCache(regionName), this.settings, metadata, properties);
    }

    public CollectionRegion buildCollectionRegion(String regionName, Properties properties, CacheDataDescription metadata) throws CacheException {
        return new EhcacheCollectionRegion(this.accessStrategyFactory, this.getCache(regionName), this.settings, metadata, properties);
    }

    public QueryResultsRegion buildQueryResultsRegion(String regionName, Properties properties) throws CacheException {
        return new EhcacheQueryResultsRegion(this.accessStrategyFactory, this.getCache(regionName), properties);
    }

    @InjectService
    public void setClassLoaderService(ClassLoaderService classLoaderService) {
        this.classLoaderService = classLoaderService;
    }

    public TimestampsRegion buildTimestampsRegion(String regionName, Properties properties) throws CacheException {
        return new EhcacheTimestampsRegion(this.accessStrategyFactory, this.getCache(regionName), properties);
    }

    private Ehcache getCache(String name) throws CacheException {
        try {
            Ehcache cache = this.manager.getEhcache(name);
            if (cache == null) {
                LOG.unableToFindEhCacheConfiguration(name);
                this.manager.addCache(name);
                cache = this.manager.getEhcache(name);
                LOG.debug("started EHCache region: " + name);
            }
            HibernateEhcacheUtils.validateEhcache(cache);
            return cache;
        }
        catch (net.sf.ehcache.CacheException e) {
            throw new CacheException((Throwable)e);
        }
    }

    protected URL loadResource(String configurationResourceName) {
        URL url = null;
        if (this.classLoaderService != null) {
            url = this.classLoaderService.locateResource(configurationResourceName);
        }
        if (url == null) {
            ClassLoader standardClassloader = Thread.currentThread().getContextClassLoader();
            if (standardClassloader != null) {
                url = standardClassloader.getResource(configurationResourceName);
            }
            if (url == null) {
                url = AbstractEhcacheRegionFactory.class.getResource(configurationResourceName);
            }
            if (url == null) {
                try {
                    url = new URL(configurationResourceName);
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debugf("Creating EhCacheRegionFactory from a specified resource: %s.  Resolved to URL: %s", configurationResourceName, url);
        }
        if (url == null) {
            LOG.unableToLoadConfiguration(configurationResourceName);
        }
        return url;
    }

    public AccessType getDefaultAccessType() {
        return AccessType.READ_WRITE;
    }
}

