/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.reflect.hosted;

import com.oracle.svm.core.meta.SharedMethod;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.LogicConstantNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.spi.Canonicalizable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;

@NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
final class CanBeStaticallyBoundNode
extends LogicNode
implements Canonicalizable {
    public static final NodeClass<CanBeStaticallyBoundNode> TYPE = NodeClass.create(CanBeStaticallyBoundNode.class);
    private final ResolvedJavaMethod method;

    protected CanBeStaticallyBoundNode(ResolvedJavaMethod method) {
        super(TYPE);
        this.method = method;
    }

    public Node canonical(CanonicalizerTool tool) {
        if (this.method.canBeStaticallyBound()) {
            return LogicConstantNode.tautology();
        }
        if (this.method instanceof SharedMethod) {
            return LogicConstantNode.contradiction();
        }
        return this;
    }
}

