/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.substitute;

import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.hosted.substitute.AnnotationSubstitutionProcessor;
import com.oracle.svm.hosted.substitute.DeletedMethod;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.NodePlugin;

public final class DeletedFieldsPlugin
implements NodePlugin {
    public boolean handleLoadField(GraphBuilderContext b, ValueNode object, ResolvedJavaField field) {
        return DeletedFieldsPlugin.handleField(b, field, true);
    }

    public boolean handleLoadStaticField(GraphBuilderContext b, ResolvedJavaField field) {
        return DeletedFieldsPlugin.handleField(b, field, true);
    }

    public boolean handleStoreField(GraphBuilderContext b, ValueNode object, ResolvedJavaField field, ValueNode value) {
        return DeletedFieldsPlugin.handleField(b, field, false);
    }

    public boolean handleStoreStaticField(GraphBuilderContext b, ResolvedJavaField field, ValueNode value) {
        return DeletedFieldsPlugin.handleField(b, field, false);
    }

    private static boolean handleField(GraphBuilderContext b, ResolvedJavaField field, boolean isLoad) {
        Delete deleteAnnotation = (Delete)field.getAnnotation(Delete.class);
        if (deleteAnnotation == null) {
            return false;
        }
        String msg = AnnotationSubstitutionProcessor.deleteErrorMessage((AnnotatedElement)field, deleteAnnotation, false);
        ConstantNode msgNode = ConstantNode.forConstant((JavaConstant)SubstrateObjectConstant.forObject(msg), (MetaAccessProvider)b.getMetaAccess(), (StructuredGraph)b.getGraph());
        ResolvedJavaMethod reportErrorMethod = b.getMetaAccess().lookupJavaMethod((Executable)DeletedMethod.reportErrorMethod);
        b.handleReplacedInvoke(CallTargetNode.InvokeKind.Static, reportErrorMethod, new ValueNode[]{msgNode}, false);
        JavaKind returnKind = reportErrorMethod.getSignature().getReturnKind();
        if (returnKind != JavaKind.Void) {
            b.pop(returnKind);
        }
        if (isLoad) {
            b.addPush(field.getJavaKind(), (ValueNode)ConstantNode.defaultForKind((JavaKind)field.getJavaKind()));
        }
        return true;
    }
}

