/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.phases;

import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.core.ParsingReason;
import com.oracle.svm.hosted.phases.EnumSwitchFeature;
import com.oracle.svm.hosted.snippets.ReflectionPlugins;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Method;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.NodePlugin;
import org.graalvm.nativeimage.ImageSingletons;

final class EnumSwitchPlugin
implements NodePlugin {
    private static final String METHOD_NAME_PREFIX = "$SWITCH_TABLE$";
    private final SnippetReflectionProvider snippetReflection;
    private final ParsingReason reason;

    EnumSwitchPlugin(SnippetReflectionProvider snippetReflection, ParsingReason reason) {
        this.snippetReflection = snippetReflection;
        this.reason = reason;
    }

    public boolean handleInvoke(GraphBuilderContext b, ResolvedJavaMethod method, ValueNode[] args) {
        Object switchTable;
        if (!method.getName().startsWith(METHOD_NAME_PREFIX) || !method.isStatic() || method.getSignature().getParameterCount(false) != 0) {
            return false;
        }
        if (this.reason == ParsingReason.PointsToAnalysis) {
            if (!method.getDeclaringClass().isInitialized()) {
                return false;
            }
            AnalysisMethod aMethod = (AnalysisMethod)method;
            EnumSwitchFeature feature = (EnumSwitchFeature)ImageSingletons.lookup(EnumSwitchFeature.class);
            aMethod.ensureGraphParsed(feature.bb);
            Boolean methodSafeForExecution = (Boolean)feature.methodsSafeForExecution.get(aMethod);
            assert (methodSafeForExecution != null) : "after-parsing hook not executed for method " + aMethod.format("%H.%n(%p)");
            if (!methodSafeForExecution.booleanValue()) {
                return false;
            }
            try {
                Method switchTableMethod = ReflectionUtil.lookupMethod((Class)aMethod.getDeclaringClass().getJavaClass(), (String)method.getName(), (Class[])new Class[0]);
                Object switchTable2 = switchTableMethod.invoke(null, new Object[0]);
                if (switchTable2 instanceof int[]) {
                    ((ReflectionPlugins.ReflectionPluginRegistry)ImageSingletons.lookup(ReflectionPlugins.ReflectionPluginRegistry.class)).add(b.getMethod(), b.bci(), switchTable2);
                }
            }
            catch (ReflectiveOperationException ex) {
                throw GraalError.shouldNotReachHere((Throwable)ex);
            }
        }
        if ((switchTable = ((ReflectionPlugins.ReflectionPluginRegistry)ImageSingletons.lookup(ReflectionPlugins.ReflectionPluginRegistry.class)).get(b.getMethod(), b.bci())) != null) {
            b.addPush(JavaKind.Object, (ValueNode)ConstantNode.forConstant((JavaConstant)this.snippetReflection.forObject(switchTable), (int)1, (boolean)true, (MetaAccessProvider)b.getMetaAccess()));
            return true;
        }
        return false;
    }
}

