/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.hosted.code.NonBytecodeStaticMethod;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.annotation.Annotation;
import java.util.Objects;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;

public abstract class EntryPointCallStubMethod
extends NonBytecodeStaticMethod {
    private static final Uninterruptible UNINTERRUPTIBLE_ANNOTATION = Objects.requireNonNull(ReflectionUtil.lookupMethod(EntryPointCallStubMethod.class, (String)"uninterruptibleAnnotationHolder", (Class[])new Class[0]).getAnnotation(Uninterruptible.class));

    protected EntryPointCallStubMethod(String name, ResolvedJavaType declaringClass, Signature signature, ConstantPool constantPool) {
        super(name, declaringClass, signature, constantPool);
    }

    @Uninterruptible(reason="Entry point", calleeMustBe=false)
    private static void uninterruptibleAnnotationHolder() {
    }

    @Override
    public final <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        if (annotationClass == Uninterruptible.class) {
            return (T)((Annotation)annotationClass.cast(UNINTERRUPTIBLE_ANNOTATION));
        }
        return null;
    }

    @Override
    public final Annotation[] getAnnotations() {
        return new Annotation[]{UNINTERRUPTIBLE_ANNOTATION};
    }

    @Override
    public final Annotation[] getDeclaredAnnotations() {
        return new Annotation[]{UNINTERRUPTIBLE_ANNOTATION};
    }
}

