/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.analysis;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.annotate.UnknownObjectField;
import com.oracle.svm.core.annotate.UnknownPrimitiveField;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.word.WordBase;

public abstract class UnknownFieldHandler {
    private Set<AnalysisField> handledUnknownValueFields = new HashSet<AnalysisField>();
    private final AnalysisMetaAccess metaAccess;

    public UnknownFieldHandler(AnalysisMetaAccess metaAccess) {
        this.metaAccess = metaAccess;
    }

    public void handleUnknownValueField(BigBang bb, AnalysisField field) {
        if (this.handledUnknownValueFields.contains(field)) {
            return;
        }
        if (!field.isAccessed()) {
            return;
        }
        UnknownObjectField unknownObjectField = (UnknownObjectField)field.getAnnotation(UnknownObjectField.class);
        UnknownPrimitiveField unknownPrimitiveField = (UnknownPrimitiveField)field.getAnnotation(UnknownPrimitiveField.class);
        if (unknownObjectField != null) {
            assert (!Modifier.isFinal(field.getModifiers())) : "@UnknownObjectField annotated field " + field.format("%H.%n") + " cannot be final";
            assert (field.getJavaKind() == JavaKind.Object);
            field.setCanBeNull(unknownObjectField.canBeNull());
            List<AnalysisType> aAnnotationTypes = this.extractAnnotationTypes(field, unknownObjectField);
            for (AnalysisType type : aAnnotationTypes) {
                type.registerAsAllocated(null);
            }
            this.handleUnknownObjectField(bb, field, aAnnotationTypes.toArray(new AnalysisType[0]));
        } else if (unknownPrimitiveField != null) {
            assert (!Modifier.isFinal(field.getModifiers())) : "@UnknownPrimitiveField annotated field " + field.format("%H.%n") + " cannot be final";
            field.registerAsWritten(null);
        }
        this.handledUnknownValueFields.add(field);
    }

    private List<AnalysisType> extractAnnotationTypes(AnalysisField field, UnknownObjectField unknownObjectField) {
        ArrayList annotationTypes = new ArrayList(Arrays.asList(unknownObjectField.types()));
        for (String string : unknownObjectField.fullyQualifiedTypes()) {
            try {
                Class<?> annotationType = Class.forName(string);
                annotationTypes.add(annotationType);
            }
            catch (ClassNotFoundException e) {
                throw JVMCIError.shouldNotReachHere((String)("Annotation type not found " + string));
            }
        }
        ArrayList<AnalysisType> aAnnotationTypes = new ArrayList<AnalysisType>();
        AnalysisType declaredType = field.getType();
        for (Class clazz : annotationTypes) {
            AnalysisType aAnnotationType = this.metaAccess.lookupJavaType(clazz);
            assert (!WordBase.class.isAssignableFrom(clazz)) : "Annotation type must not be a subtype of WordBase: field: " + field + " | declared type: " + declaredType + " | annotation type: " + clazz;
            assert (declaredType.isAssignableFrom((ResolvedJavaType)aAnnotationType)) : "Annotation type must be a subtype of the declared type: field: " + field + " | declared type: " + declaredType + " | annotation type: " + clazz;
            assert (aAnnotationType.isArray() || aAnnotationType.isInstanceClass() && !Modifier.isAbstract(aAnnotationType.getModifiers())) : "Annotation type cannot be abstract: field: " + field + " | annotation type " + aAnnotationType;
            aAnnotationTypes.add(aAnnotationType);
        }
        return aAnnotationTypes;
    }

    protected abstract void handleUnknownObjectField(BigBang var1, AnalysisField var2, AnalysisType ... var3);

    public void cleanupAfterAnalysis() {
        this.handledUnknownValueFields = null;
    }
}

