/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.graal.pointsto.util.GraalAccess;
import com.oracle.svm.core.OS;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.InterruptImageBuilding;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.AbstractNativeImageClassLoaderSupport;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.NativeImageClassLoaderPostProcessing;
import com.oracle.svm.hosted.NativeImageClassLoaderSupport;
import com.oracle.svm.hosted.NativeImageGenerator;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.NativeImageSystemClassLoader;
import com.oracle.svm.util.ClassUtil;
import com.oracle.svm.util.ModuleSupport;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Timer;
import java.util.TimerTask;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Architecture;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;

public class NativeImageGeneratorRunner {
    private volatile NativeImageGenerator generator;
    public static final String IMAGE_BUILDER_ARG_FILE_OPTION = "--image-args-file=";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int exitStatus;
        List<String> arguments = new ArrayList<String>(Arrays.asList(args));
        arguments = NativeImageGeneratorRunner.extractDriverArguments(arguments);
        String[] classPath = NativeImageGeneratorRunner.extractImagePathEntries(arguments, "-imagecp");
        String[] modulePath = NativeImageGeneratorRunner.extractImagePathEntries(arguments, "-imagemp");
        final int watchPID = NativeImageGeneratorRunner.extractWatchPID(arguments);
        TimerTask timerTask = null;
        if (watchPID >= 0) {
            VMError.guarantee(OS.getCurrent().hasProcFS, "-watchpid <pid> requires system with /proc");
            timerTask = new TimerTask(){
                int cmdlineHashCode = 0;

                @Override
                public void run() {
                    try {
                        int currentCmdlineHashCode = Arrays.hashCode(Files.readAllBytes(Paths.get("/proc/" + watchPID + "/cmdline", new String[0])));
                        if (this.cmdlineHashCode == 0) {
                            this.cmdlineHashCode = currentCmdlineHashCode;
                        } else if (currentCmdlineHashCode != this.cmdlineHashCode) {
                            System.exit(1);
                        }
                    }
                    catch (IOException e) {
                        System.exit(1);
                    }
                }
            };
            Timer timer = new Timer("native-image pid watcher");
            timer.scheduleAtFixedRate(timerTask, 0L, 1000L);
        }
        ClassLoader applicationClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ImageClassLoader imageClassLoader = NativeImageGeneratorRunner.installNativeImageClassLoader(classPath, modulePath, arguments);
            List<String> remainingArguments = imageClassLoader.classLoaderSupport.getRemainingArguments();
            if (!remainingArguments.isEmpty()) {
                throw UserError.abort("Unknown options: %s", String.join((CharSequence)" ", remainingArguments));
            }
            exitStatus = new NativeImageGeneratorRunner().build(imageClassLoader);
        }
        catch (UserError.UserException e) {
            NativeImageGeneratorRunner.reportUserError(e.getMessage());
            exitStatus = 1;
        }
        catch (InterruptImageBuilding e) {
            if (e.getReason().isPresent()) {
                if (!e.getReason().get().isEmpty()) {
                    NativeImageGeneratorRunner.info(e.getReason().get());
                }
                exitStatus = 0;
            } else {
                exitStatus = 3;
            }
        }
        catch (Throwable err) {
            NativeImageGeneratorRunner.reportFatalError(err);
            exitStatus = 1;
        }
        finally {
            NativeImageGeneratorRunner.uninstallNativeImageClassLoader();
            Thread.currentThread().setContextClassLoader(applicationClassLoader);
            if (timerTask != null) {
                timerTask.cancel();
            }
        }
        System.exit(exitStatus);
    }

    public static void uninstallNativeImageClassLoader() {
        ClassLoader loader = ClassLoader.getSystemClassLoader();
        if (loader instanceof NativeImageSystemClassLoader) {
            ((NativeImageSystemClassLoader)loader).setNativeImageClassLoader(null);
        }
    }

    public static ImageClassLoader installNativeImageClassLoader(String[] classpath, String[] modulepath, List<String> arguments) {
        NativeImageSystemClassLoader nativeImageSystemClassLoader = NativeImageSystemClassLoader.singleton();
        AbstractNativeImageClassLoaderSupport nativeImageClassLoaderSupport = NativeImageGeneratorRunner.createNativeImageClassLoaderSupport(nativeImageSystemClassLoader.defaultSystemClassLoader, classpath, modulepath);
        nativeImageClassLoaderSupport.setupHostedOptionParser(arguments);
        for (NativeImageClassLoaderPostProcessing postProcessing : ServiceLoader.load(NativeImageClassLoaderPostProcessing.class)) {
            postProcessing.apply(nativeImageClassLoaderSupport);
        }
        ClassLoader nativeImageClassLoader = nativeImageClassLoaderSupport.getClassLoader();
        Thread.currentThread().setContextClassLoader(nativeImageClassLoader);
        nativeImageSystemClassLoader.setNativeImageClassLoader(nativeImageClassLoader);
        if (JavaVersionUtil.JAVA_SPEC >= 11 && !nativeImageClassLoaderSupport.imagecp.isEmpty()) {
            ModuleSupport.openModuleByClass(JavaVersionUtil.class, null);
        }
        NativeImageGenerator.setSystemPropertiesForImageEarly();
        return new ImageClassLoader(NativeImageGenerator.getTargetPlatform(nativeImageClassLoader), nativeImageClassLoaderSupport);
    }

    private static AbstractNativeImageClassLoaderSupport createNativeImageClassLoaderSupport(ClassLoader defaultSystemClassLoader, String[] classpath, String[] modulePath) {
        if (JavaVersionUtil.JAVA_SPEC >= 11) {
            try {
                Class<?> nativeImageClassLoaderSupport = Class.forName("com.oracle.svm.hosted.jdk.NativeImageClassLoaderSupportJDK11OrLater");
                Constructor<?> nativeImageClassLoaderSupportConstructor = nativeImageClassLoaderSupport.getConstructor(ClassLoader.class, String[].class, String[].class);
                return (AbstractNativeImageClassLoaderSupport)nativeImageClassLoaderSupportConstructor.newInstance(defaultSystemClassLoader, classpath, modulePath);
            }
            catch (ReflectiveOperationException e) {
                throw VMError.shouldNotReachHere("Unable to reflectively instantiate module-aware NativeImageClassLoaderSupport", e);
            }
        }
        return new NativeImageClassLoaderSupport(defaultSystemClassLoader, classpath, modulePath);
    }

    public static List<String> extractDriverArguments(List<String> args) {
        ArrayList result = args.stream().filter(arg -> !arg.startsWith(IMAGE_BUILDER_ARG_FILE_OPTION)).collect(Collectors.toCollection(ArrayList::new));
        Optional<String> argsFile = args.stream().filter(arg -> arg.startsWith(IMAGE_BUILDER_ARG_FILE_OPTION)).findFirst();
        if (argsFile.isPresent()) {
            String argFilePath = argsFile.get().substring(IMAGE_BUILDER_ARG_FILE_OPTION.length());
            try {
                String options = new String(Files.readAllBytes(Paths.get(argFilePath, new String[0])));
                result.addAll(Arrays.asList(options.split("\u0000")));
            }
            catch (IOException e) {
                throw VMError.shouldNotReachHere("Exception occurred during image builder argument file processing.", e);
            }
        }
        return result;
    }

    public static String[] extractImagePathEntries(List<String> arguments, String pathPrefix) {
        int cpArgIndex = arguments.indexOf(pathPrefix);
        String msgTail = " '" + pathPrefix + " <Path entries separated by File.pathSeparator>' argument.";
        if (cpArgIndex == -1) {
            return new String[0];
        }
        arguments.remove(cpArgIndex);
        try {
            String imageClasspath = arguments.remove(cpArgIndex);
            return imageClasspath.split(File.pathSeparator, Integer.MAX_VALUE);
        }
        catch (IndexOutOfBoundsException e) {
            throw UserError.abort("Missing path entries for %s", msgTail);
        }
    }

    public static int extractWatchPID(List<String> arguments) {
        int cpIndex = arguments.indexOf("-watchpid");
        if (cpIndex >= 0) {
            if (cpIndex + 1 >= arguments.size()) {
                throw UserError.abort("ProcessID must be provided after the '%s' argument.", "-watchpid");
            }
            arguments.remove(cpIndex);
            String pidStr = arguments.get(cpIndex);
            arguments.remove(cpIndex);
            return Integer.parseInt(pidStr);
        }
        return -1;
    }

    public static boolean isValidJavaVersion() {
        return Boolean.getBoolean("substratevm.IgnoreGraalVersionCheck") || JavaVersionUtil.JAVA_SPEC <= 8;
    }

    private static void reportToolUserError(String msg) {
        NativeImageGeneratorRunner.reportUserError("native-image " + msg);
    }

    private static boolean isValidArchitecture() {
        Architecture originalTargetArch = GraalAccess.getOriginalTarget().arch;
        return originalTargetArch instanceof AMD64 || originalTargetArch instanceof AArch64;
    }

    private static boolean isValidOperatingSystem() {
        OS currentOs = OS.getCurrent();
        return currentOs == OS.LINUX || currentOs == OS.DARWIN || currentOs == OS.WINDOWS;
    }

    /*
     * Exception decompiling
     */
    private int buildImage(ImageClassLoader classLoader) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [32[CATCHBLOCK]], but top level block is 13[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean verifyValidJavaVersionAndPlatform() {
        if (!NativeImageGeneratorRunner.isValidJavaVersion()) {
            NativeImageGeneratorRunner.reportToolUserError("supports only Java 1.8 with an update version 40+. Detected Java version is: " + NativeImageGeneratorRunner.getJavaVersion());
            return false;
        }
        if (!NativeImageGeneratorRunner.isValidArchitecture()) {
            NativeImageGeneratorRunner.reportToolUserError("runs only on architecture AMD64. Detected architecture: " + ClassUtil.getUnqualifiedName(GraalAccess.getOriginalTarget().arch.getClass()));
        }
        if (!NativeImageGeneratorRunner.isValidOperatingSystem()) {
            NativeImageGeneratorRunner.reportToolUserError("runs on Linux, Mac OS X and Windows only. Detected OS: " + System.getProperty("os.name"));
            return false;
        }
        return true;
    }

    public static String getJavaVersion() {
        return System.getProperty("java.version");
    }

    protected static void reportFatalError(Throwable e) {
        System.err.print("Fatal error: ");
        e.printStackTrace();
    }

    protected static void reportFatalError(Throwable e, String msg) {
        System.err.print("Fatal error: " + msg);
        e.printStackTrace();
    }

    public static void reportUserError(String msg) {
        System.err.println("Error: " + msg);
    }

    public static void reportUserError(Throwable e, OptionValues parsedHostedOptions) {
        NativeImageGeneratorRunner.reportUserException(e, parsedHostedOptions, NativeImageGeneratorRunner::reportUserError);
    }

    private static void reportUserException(Throwable e, OptionValues parsedHostedOptions, Consumer<String> report) {
        if (e instanceof UserError.UserException) {
            UserError.UserException ue = (UserError.UserException)e;
            for (String message : ue.getMessages()) {
                report.accept(message);
            }
        } else {
            report.accept(e.getMessage());
        }
        if (parsedHostedOptions != null && ((Boolean)NativeImageOptions.ReportExceptionStackTraces.getValue(parsedHostedOptions)).booleanValue()) {
            e.printStackTrace();
        } else {
            report.accept("Use " + SubstrateOptionsParser.commandArgument(NativeImageOptions.ReportExceptionStackTraces, "+") + " to print stacktrace of underlying exception");
        }
    }

    private static void info(String msg) {
        System.out.println("Info: " + msg);
    }

    private static void warn(String msg) {
        System.err.println("Warning: " + msg);
    }

    public int build(ImageClassLoader imageClassLoader) {
        return this.buildImage(imageClassLoader);
    }

    private static /* synthetic */ UserError.UserException lambda$buildImage$3(String moduleName) {
        return UserError.abort("module %s does not have a ModuleMainClass attribute, use -m <module>/<main-class>", moduleName);
    }

    private static /* synthetic */ UserError.UserException lambda$buildImage$2(String moduleName) {
        return UserError.abort("Module " + moduleName + " for mainclass not found.", new Object[0]);
    }

    public static class JDK9Plus {
        public static void main(String[] args) {
            ModuleSupport.exportAndOpenAllPackagesToUnnamed((String)"org.graalvm.sdk", (boolean)false);
            ModuleSupport.exportAndOpenAllPackagesToUnnamed((String)"org.graalvm.truffle", (boolean)false);
            ModuleSupport.exportAndOpenAllPackagesToUnnamed((String)"jdk.internal.vm.ci", (boolean)false);
            ModuleSupport.exportAndOpenAllPackagesToUnnamed((String)"jdk.internal.vm.compiler", (boolean)false);
            ModuleSupport.exportAndOpenAllPackagesToUnnamed((String)"jdk.internal.vm.compiler.management", (boolean)true);
            ModuleSupport.exportAndOpenAllPackagesToUnnamed((String)"com.oracle.graal.graal_enterprise", (boolean)true);
            ModuleSupport.exportAndOpenPackageToUnnamed((String)"java.base", (String)"jdk.internal.loader", (boolean)false);
            if (JavaVersionUtil.JAVA_SPEC >= 17) {
                ModuleSupport.exportAndOpenPackageToUnnamed((String)"java.base", (String)"jdk.internal.misc", (boolean)false);
            }
            ModuleSupport.exportAndOpenPackageToUnnamed((String)"java.base", (String)"sun.text.spi", (boolean)false);
            ModuleSupport.exportAndOpenPackageToUnnamed((String)"java.base", (String)"jdk.internal.org.objectweb.asm", (boolean)false);
            if (JavaVersionUtil.JAVA_SPEC >= 17) {
                ModuleSupport.exportAndOpenPackageToUnnamed((String)"java.base", (String)"sun.reflect.annotation", (boolean)false);
                ModuleSupport.exportAndOpenPackageToUnnamed((String)"java.base", (String)"sun.security.jca", (boolean)false);
                ModuleSupport.exportAndOpenPackageToUnnamed((String)"jdk.jdeps", (String)"com.sun.tools.classfile", (boolean)false);
            }
            NativeImageGeneratorRunner.main(args);
        }
    }
}

