/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.ClassLoaderSupport;
import com.oracle.svm.core.util.ClasspathUtils;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.AbstractNativeImageClassLoaderSupport;
import com.oracle.svm.hosted.NativeImageSystemClassLoader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Stream;

public class ClassLoaderSupportImpl
extends ClassLoaderSupport {
    private final AbstractNativeImageClassLoaderSupport classLoaderSupport;
    private final ClassLoader imageClassLoader;

    protected ClassLoaderSupportImpl(AbstractNativeImageClassLoaderSupport classLoaderSupport) {
        this.classLoaderSupport = classLoaderSupport;
        this.imageClassLoader = classLoaderSupport.getClassLoader();
    }

    @Override
    protected boolean isNativeImageClassLoaderImpl(ClassLoader loader) {
        return loader == this.imageClassLoader || loader instanceof NativeImageSystemClassLoader;
    }

    @Override
    public void collectResources(ClassLoaderSupport.ResourceCollector resourceCollector) {
        this.classLoaderSupport.classpath().stream().forEach(classpathFile -> {
            try {
                if (Files.isDirectory(classpathFile, new LinkOption[0])) {
                    ClassLoaderSupportImpl.scanDirectory(classpathFile, resourceCollector);
                } else if (ClasspathUtils.isJar(classpathFile)) {
                    ClassLoaderSupportImpl.scanJar(classpathFile, resourceCollector);
                }
            }
            catch (IOException ex) {
                throw UserError.abort("Unable to handle classpath element '%s'. Make sure that all classpath entries are either directories or valid jar files.", classpathFile);
            }
        });
    }

    private static void scanDirectory(Path root, ClassLoaderSupport.ResourceCollector collector) throws IOException {
        HashMap<String, List> matchedDirectoryResources = new HashMap<String, List>();
        HashSet<String> allEntries = new HashSet<String>();
        ArrayDeque<Path> queue = new ArrayDeque<Path>();
        queue.push(root);
        while (!queue.isEmpty()) {
            Throwable throwable;
            String relativeFilePath;
            Path entry = (Path)queue.pop();
            if (entry != root) {
                relativeFilePath = root.relativize(entry).toString().replace(File.separatorChar, '/');
                allEntries.add(relativeFilePath);
            } else {
                relativeFilePath = "";
            }
            if (Files.isDirectory(entry, new LinkOption[0])) {
                if (collector.isIncluded(null, relativeFilePath)) {
                    matchedDirectoryResources.put(relativeFilePath, new ArrayList());
                }
                Stream<Path> files = Files.list(entry);
                throwable = null;
                try {
                    files.forEach(queue::push);
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (files == null) continue;
                    if (throwable != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    files.close();
                    continue;
                }
            }
            if (!collector.isIncluded(null, relativeFilePath)) continue;
            InputStream is = Files.newInputStream(entry, new OpenOption[0]);
            throwable = null;
            try {
                collector.addResource(null, relativeFilePath, is);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (is == null) continue;
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    continue;
                }
                is.close();
            }
        }
        for (String entry : allEntries) {
            int last = entry.lastIndexOf(47);
            String key = last == -1 ? "" : entry.substring(0, last);
            List dirContent = (List)matchedDirectoryResources.get(key);
            if (dirContent == null || dirContent.contains(entry)) continue;
            dirContent.add(entry.substring(last + 1));
        }
        matchedDirectoryResources.forEach((dir, content) -> {
            content.sort(Comparator.naturalOrder());
            collector.addDirectoryResource(null, (String)dir, String.join((CharSequence)System.lineSeparator(), content));
        });
    }

    private static void scanJar(Path jarPath, ClassLoaderSupport.ResourceCollector collector) throws IOException {
        try (JarFile jf = new JarFile(jarPath.toFile());){
            Enumeration<JarEntry> entries = jf.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (entry.isDirectory()) {
                    String dirName = entry.getName().substring(0, entry.getName().length() - 1);
                    if (!collector.isIncluded(null, dirName)) continue;
                    collector.addDirectoryResource(null, dirName, "");
                    continue;
                }
                if (!collector.isIncluded(null, entry.getName())) continue;
                InputStream is = jf.getInputStream(entry);
                Throwable throwable = null;
                try {
                    collector.addResource(null, entry.getName(), is);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
        }
    }

    @Override
    public List<ResourceBundle> getResourceBundle(String bundleName, Locale locale) {
        return Collections.singletonList(ResourceBundle.getBundle(bundleName, locale, this.imageClassLoader));
    }
}

