/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal;

import com.oracle.svm.core.stack.SubstrateStackIntrospection;
import com.oracle.svm.graal.GraalSupport;
import com.oracle.svm.util.ClassUtil;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.code.stack.StackIntrospection;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.api.runtime.GraalRuntime;
import org.graalvm.compiler.core.target.Backend;
import org.graalvm.compiler.runtime.RuntimeProvider;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class SubstrateGraalRuntime
implements GraalRuntime,
RuntimeProvider {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    public SubstrateGraalRuntime() {
    }

    public String getName() {
        return ClassUtil.getUnqualifiedName(this.getClass());
    }

    public <T> T getCapability(Class<T> clazz) {
        if (clazz == RuntimeProvider.class) {
            return (T)this;
        }
        if (clazz == SnippetReflectionProvider.class) {
            return (T)GraalSupport.getRuntimeConfig().getSnippetReflection();
        }
        if (clazz == StackIntrospection.class) {
            return (T)SubstrateStackIntrospection.SINGLETON;
        }
        return null;
    }

    public Backend getHostBackend() {
        return GraalSupport.getRuntimeConfig().getBackendForNormalMethod();
    }

    public <T extends Architecture> Backend getBackend(Class<T> arch) {
        assert (arch.isInstance(GraalSupport.getRuntimeConfig().getBackendForNormalMethod().getTarget().arch));
        return GraalSupport.getRuntimeConfig().getBackendForNormalMethod();
    }
}

