/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.threadlocal;

import com.oracle.svm.core.FrameAccess;
import com.oracle.svm.core.annotate.UnknownPrimitiveField;
import com.oracle.svm.core.threadlocal.FastThreadLocal;
import com.oracle.svm.core.threadlocal.FastThreadLocalBytes;
import com.oracle.svm.core.threadlocal.FastThreadLocalInt;
import com.oracle.svm.core.threadlocal.FastThreadLocalLong;
import com.oracle.svm.core.threadlocal.FastThreadLocalObject;
import com.oracle.svm.core.threadlocal.FastThreadLocalWord;
import com.oracle.svm.core.util.VMError;
import java.util.function.IntSupplier;
import jdk.vm.ci.meta.JavaKind;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.WordBase;

public class VMThreadLocalInfo {
    public static final Class<? extends FastThreadLocal>[] THREAD_LOCAL_CLASSES = new Class[]{FastThreadLocalInt.class, FastThreadLocalLong.class, FastThreadLocalWord.class, FastThreadLocalObject.class};
    public final Class<? extends FastThreadLocal> threadLocalClass;
    public final IntSupplier sizeSupplier;
    public final LocationIdentity locationIdentity;
    public final boolean isObject;
    public final JavaKind storageKind;
    public final Class<?> valueClass;
    public final int maxOffset;
    public final boolean allowFloatingReads;
    public final String name;
    @UnknownPrimitiveField
    public int offset;
    @UnknownPrimitiveField
    public int sizeInBytes;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public static Class<?> getValueClass(Class<? extends FastThreadLocal> threadLocalClass) {
        if (threadLocalClass == FastThreadLocalInt.class) {
            return Integer.TYPE;
        }
        if (threadLocalClass == FastThreadLocalLong.class) {
            return Long.TYPE;
        }
        if (threadLocalClass == FastThreadLocalWord.class) {
            return WordBase.class;
        }
        if (threadLocalClass == FastThreadLocalObject.class) {
            return Object.class;
        }
        throw VMError.shouldNotReachHere();
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public VMThreadLocalInfo(FastThreadLocal threadLocal) {
        this.threadLocalClass = threadLocal.getClass();
        this.locationIdentity = threadLocal.getLocationIdentity();
        this.maxOffset = threadLocal.getMaxOffset();
        this.allowFloatingReads = threadLocal.getAllowFloatingReads();
        this.name = threadLocal.getName();
        this.sizeSupplier = this.threadLocalClass == FastThreadLocalBytes.class ? ((FastThreadLocalBytes)threadLocal).getSizeSupplier() : null;
        if (this.threadLocalClass == FastThreadLocalObject.class) {
            this.isObject = true;
            this.valueClass = ((FastThreadLocalObject)threadLocal).getValueClass();
        } else {
            this.isObject = false;
            this.valueClass = null;
        }
        if (this.threadLocalClass == FastThreadLocalInt.class) {
            this.storageKind = JavaKind.Int;
        } else if (this.threadLocalClass == FastThreadLocalLong.class) {
            this.storageKind = JavaKind.Long;
        } else if (this.threadLocalClass == FastThreadLocalWord.class) {
            this.storageKind = FrameAccess.getWordKind();
        } else if (this.threadLocalClass == FastThreadLocalObject.class) {
            this.storageKind = JavaKind.Object;
        } else if (this.threadLocalClass == FastThreadLocalBytes.class) {
            this.storageKind = null;
        } else {
            throw VMError.shouldNotReachHere();
        }
        this.offset = -1;
        this.sizeInBytes = -1;
    }

    public String toString() {
        return this.name + "@" + this.offset;
    }
}

