/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix;

import com.oracle.svm.core.SubstrateSegfaultHandler;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.c.function.CEntryPointOptions;
import com.oracle.svm.core.headers.LibC;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.os.MemoryProtectionKeyProvider;
import com.oracle.svm.core.posix.headers.Signal;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.function.CEntryPoint;
import org.graalvm.nativeimage.c.function.CEntryPointLiteral;
import org.graalvm.nativeimage.c.struct.SizeOf;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

class PosixSubstrateSegfaultHandler
extends SubstrateSegfaultHandler {
    private static final CEntryPointLiteral<Signal.AdvancedSignalDispatcher> advancedSignalDispatcher = CEntryPointLiteral.create(PosixSubstrateSegfaultHandler.class, (String)"dispatch", (Class[])new Class[]{Integer.TYPE, Signal.siginfo_t.class, Signal.ucontext_t.class});

    PosixSubstrateSegfaultHandler() {
    }

    @CEntryPoint(include=CEntryPoint.NotIncludedAutomatically.class)
    @CEntryPointOptions(prologue=CEntryPointOptions.NoPrologue.class, epilogue=CEntryPointOptions.NoEpilogue.class, publishAs=CEntryPointOptions.Publish.NotPublished)
    @RestrictHeapAccess(access=RestrictHeapAccess.Access.NO_ALLOCATION, reason="Must not allocate in segfault signal handler.")
    @Uninterruptible(reason="Must be uninterruptible until it gets immune to safepoints")
    private static void dispatch(int signalNumber, Signal.siginfo_t sigInfo, Signal.ucontext_t uContext) {
        if (MemoryProtectionKeyProvider.isAvailable()) {
            MemoryProtectionKeyProvider.singleton().handleSegfault(sigInfo);
        }
        if (PosixSubstrateSegfaultHandler.tryEnterIsolate(uContext)) {
            PosixSubstrateSegfaultHandler.dump(sigInfo, uContext);
            throw VMError.shouldNotReachHere();
        }
    }

    @Override
    protected void printSignalInfo(Log log, PointerBase signalInfo) {
        if (MemoryProtectionKeyProvider.isAvailable()) {
            MemoryProtectionKeyProvider.singleton().printSignalInfo(signalInfo);
        } else {
            Signal.siginfo_t sigInfo = (Signal.siginfo_t)signalInfo;
            log.string("siginfo: si_signo: ").signed(sigInfo.si_signo()).string(", si_code: ").signed(sigInfo.si_code());
            if (sigInfo.si_errno() != 0) {
                log.string(", si_errno: ").signed(sigInfo.si_errno());
            }
            log.string(", si_addr: ").zhex((WordBase)sigInfo.si_addr());
            log.newline();
        }
    }

    @Override
    protected void installInternal() {
        int structSigActionSize = SizeOf.get(Signal.sigaction.class);
        Signal.sigaction structSigAction = (Signal.sigaction)StackValue.get((int)structSigActionSize);
        LibC.memset(structSigAction, WordFactory.signed((int)0), WordFactory.unsigned((int)structSigActionSize));
        structSigAction.sa_flags(Signal.SA_SIGINFO() | Signal.SA_NODEFER());
        structSigAction.sa_sigaction((Signal.AdvancedSignalDispatcher)advancedSignalDispatcher.getFunctionPointer());
        Signal.sigaction(Signal.SignalEnum.SIGSEGV.getCValue(), structSigAction, (Signal.sigaction)WordFactory.nullPointer());
        Signal.sigaction(Signal.SignalEnum.SIGBUS.getCValue(), structSigAction, (Signal.sigaction)WordFactory.nullPointer());
    }
}

