/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.RecomputeFieldValue;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

@Platforms(value={Platform.HOSTED_ONLY.class})
class ServiceKeyComputer
implements RecomputeFieldValue.CustomFieldValueComputer {
    ServiceKeyComputer() {
    }

    @Override
    public Object compute(MetaAccessProvider metaAccess, ResolvedJavaField original, ResolvedJavaField annotated, Object receiver) {
        try {
            Class<?> serviceKey = Class.forName("java.security.Provider$ServiceKey");
            Constructor constructor = ReflectionUtil.lookupConstructor(serviceKey, (Class[])new Class[]{String.class, String.class, Boolean.TYPE});
            return constructor.newInstance("", "", false);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }
}

